--
-- PostgreSQL database dump
--

-- Dumped from database version 14.2
-- Dumped by pg_dump version 14.2

-- Started on 2022-08-24 08:06:27

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

--
-- TOC entry 27 (class 2615 OID 2452377)
-- Name: a_aeropuerto_superficie; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA a_aeropuerto_superficie;


ALTER SCHEMA a_aeropuerto_superficie OWNER TO postgres;

--
-- TOC entry 23 (class 2615 OID 2452378)
-- Name: catalogo_objetos; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA catalogo_objetos;


ALTER SCHEMA catalogo_objetos OWNER TO postgres;

--
-- TOC entry 31 (class 2615 OID 2452379)
-- Name: d_linderos_propiedad; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA d_linderos_propiedad;


ALTER SCHEMA d_linderos_propiedad OWNER TO postgres;

--
-- TOC entry 30 (class 2615 OID 2452380)
-- Name: gs_asociado_poblados; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA gs_asociado_poblados;


ALTER SCHEMA gs_asociado_poblados OWNER TO postgres;

--
-- TOC entry 29 (class 2615 OID 2452381)
-- Name: gs_construcciones; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA gs_construcciones;


ALTER SCHEMA gs_construcciones OWNER TO postgres;

--
-- TOC entry 19 (class 2615 OID 2452382)
-- Name: gs_recreacion; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA gs_recreacion;


ALTER SCHEMA gs_recreacion OWNER TO postgres;

--
-- TOC entry 18 (class 2615 OID 2452383)
-- Name: ho_aguas_interiores; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA ho_aguas_interiores;


ALTER SCHEMA ho_aguas_interiores OWNER TO postgres;

--
-- TOC entry 32 (class 2615 OID 2452384)
-- Name: ho_puertos_muelles; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA ho_puertos_muelles;


ALTER SCHEMA ho_puertos_muelles OWNER TO postgres;

--
-- TOC entry 15 (class 2615 OID 2452385)
-- Name: ho_regulacion_zonas_restringidas; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA ho_regulacion_zonas_restringidas;


ALTER SCHEMA ho_regulacion_zonas_restringidas OWNER TO postgres;

--
-- TOC entry 12 (class 2615 OID 2452386)
-- Name: ho_zonas_costeras; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA ho_zonas_costeras;


ALTER SCHEMA ho_zonas_costeras OWNER TO postgres;

--
-- TOC entry 22 (class 2615 OID 2452387)
-- Name: ii_agropecuaria; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA ii_agropecuaria;


ALTER SCHEMA ii_agropecuaria OWNER TO postgres;

--
-- TOC entry 11 (class 2615 OID 2452388)
-- Name: it_asociado_transportacion; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA it_asociado_transportacion;


ALTER SCHEMA it_asociado_transportacion OWNER TO postgres;

--
-- TOC entry 17 (class 2615 OID 2452389)
-- Name: it_cruces_enlaces; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA it_cruces_enlaces;


ALTER SCHEMA it_cruces_enlaces OWNER TO postgres;

--
-- TOC entry 14 (class 2615 OID 2452390)
-- Name: it_ferrocarriles; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA it_ferrocarriles;


ALTER SCHEMA it_ferrocarriles OWNER TO postgres;

--
-- TOC entry 28 (class 2615 OID 2452391)
-- Name: it_transporte_terrestre; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA it_transporte_terrestre;


ALTER SCHEMA it_transporte_terrestre OWNER TO postgres;

--
-- TOC entry 26 (class 2615 OID 2452392)
-- Name: proyecto_qgis3; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA proyecto_qgis3;


ALTER SCHEMA proyecto_qgis3 OWNER TO postgres;


--
-- TOC entry 25 (class 2615 OID 2452393)
-- Name: visualizacion; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA visualizacion;


ALTER SCHEMA visualizacion OWNER TO postgres;


--
-- TOC entry 5 (class 3079 OID 17608)
-- Name: fuzzystrmatch; Type: EXTENSION; Schema: -; Owner: -
--

CREATE EXTENSION IF NOT EXISTS fuzzystrmatch WITH SCHEMA public;


--
-- TOC entry 7445 (class 0 OID 0)
-- Dependencies: 5
-- Name: EXTENSION fuzzystrmatch; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION fuzzystrmatch IS 'determine similarities and distance between strings';


--
-- TOC entry 2 (class 3079 OID 16386)
-- Name: postgis; Type: EXTENSION; Schema: -; Owner: -
--

CREATE EXTENSION IF NOT EXISTS postgis WITH SCHEMA public;


--
-- TOC entry 7446 (class 0 OID 0)
-- Dependencies: 2
-- Name: EXTENSION postgis; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION postgis IS 'PostGIS geometry and geography spatial types and functions';


--
-- TOC entry 8 (class 3079 OID 18036)
-- Name: postgis_raster; Type: EXTENSION; Schema: -; Owner: -
--

CREATE EXTENSION IF NOT EXISTS postgis_raster WITH SCHEMA public;


--
-- TOC entry 7447 (class 0 OID 0)
-- Dependencies: 8
-- Name: EXTENSION postgis_raster; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION postgis_raster IS 'PostGIS raster types and functions';


--
-- TOC entry 4 (class 3079 OID 17581)
-- Name: postgis_sfcgal; Type: EXTENSION; Schema: -; Owner: -
--

CREATE EXTENSION IF NOT EXISTS postgis_sfcgal WITH SCHEMA public;


--
-- TOC entry 7448 (class 0 OID 0)
-- Dependencies: 4
-- Name: EXTENSION postgis_sfcgal; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION postgis_sfcgal IS 'PostGIS SFCGAL functions';


SET default_tablespace = '';

SET default_table_access_method = heap;

--
-- TOC entry 309 (class 1259 OID 2452394)
-- Name: aeropuerto_a; Type: TABLE; Schema: a_aeropuerto_superficie; Owner: postgres
--

CREATE TABLE a_aeropuerto_superficie.aeropuerto_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'GB005'::character varying NOT NULL,
    nam character varying(80),
    acc integer NOT NULL,
    iko character varying(4),
    fuc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32617)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'GB005'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE a_aeropuerto_superficie.aeropuerto_a OWNER TO postgres;

--
-- TOC entry 7451 (class 0 OID 0)
-- Dependencies: 309
-- Name: TABLE aeropuerto_a; Type: COMMENT; Schema: a_aeropuerto_superficie; Owner: postgres
--

COMMENT ON TABLE a_aeropuerto_superficie.aeropuerto_a IS 'Zona provista de un conjunto de pistas, instalaciones y servicios destinados al tráfico regular de aeronaves.';


--
-- TOC entry 310 (class 1259 OID 2452405)
-- Name: aeropuerto_a_gid_seq; Type: SEQUENCE; Schema: a_aeropuerto_superficie; Owner: postgres
--

CREATE SEQUENCE a_aeropuerto_superficie.aeropuerto_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE a_aeropuerto_superficie.aeropuerto_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7452 (class 0 OID 0)
-- Dependencies: 310
-- Name: aeropuerto_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: a_aeropuerto_superficie; Owner: postgres
--

ALTER SEQUENCE a_aeropuerto_superficie.aeropuerto_a_gid_seq OWNED BY a_aeropuerto_superficie.aeropuerto_a.gid;


--
-- TOC entry 311 (class 1259 OID 2452406)
-- Name: acc; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.acc (
    acc integer NOT NULL,
    acc_desc character varying(80)
);


ALTER TABLE catalogo_objetos.acc OWNER TO postgres;

--
-- TOC entry 312 (class 1259 OID 2452409)
-- Name: atc; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.atc (
    atc integer NOT NULL,
    atc_desc character varying(80)
);


ALTER TABLE catalogo_objetos.atc OWNER TO postgres;

--
-- TOC entry 313 (class 1259 OID 2452412)
-- Name: bsc; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.bsc (
    bsc integer NOT NULL,
    bsc_desc character varying(80)
);


ALTER TABLE catalogo_objetos.bsc OWNER TO postgres;

--
-- TOC entry 314 (class 1259 OID 2452415)
-- Name: catalogo_objetos; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.catalogo_objetos (
    fcode character varying(5) NOT NULL,
    objeto character varying(80),
    descripcion character varying(350),
    gid integer NOT NULL
);


ALTER TABLE catalogo_objetos.catalogo_objetos OWNER TO postgres;

--
-- TOC entry 315 (class 1259 OID 2452418)
-- Name: catalogo_objetos_gid_seq; Type: SEQUENCE; Schema: catalogo_objetos; Owner: postgres
--

CREATE SEQUENCE catalogo_objetos.catalogo_objetos_gid_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE catalogo_objetos.catalogo_objetos_gid_seq OWNER TO postgres;

--
-- TOC entry 7453 (class 0 OID 0)
-- Dependencies: 315
-- Name: catalogo_objetos_gid_seq; Type: SEQUENCE OWNED BY; Schema: catalogo_objetos; Owner: postgres
--

ALTER SEQUENCE catalogo_objetos.catalogo_objetos_gid_seq OWNED BY catalogo_objetos.catalogo_objetos.gid;


--
-- TOC entry 316 (class 1259 OID 2452419)
-- Name: dit; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.dit (
    dit integer NOT NULL,
    dit_desc character varying(80)
);


ALTER TABLE catalogo_objetos.dit OWNER TO postgres;

--
-- TOC entry 317 (class 1259 OID 2452422)
-- Name: ela; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.ela (
    ela integer NOT NULL,
    ela_desc character varying(80)
);


ALTER TABLE catalogo_objetos.ela OWNER TO postgres;

--
-- TOC entry 318 (class 1259 OID 2452425)
-- Name: fco; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.fco (
    fco integer NOT NULL,
    fco_desc character varying(80)
);


ALTER TABLE catalogo_objetos.fco OWNER TO postgres;

--
-- TOC entry 319 (class 1259 OID 2452428)
-- Name: fti; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.fti (
    fti integer NOT NULL,
    fti_desc character varying(80)
);


ALTER TABLE catalogo_objetos.fti OWNER TO postgres;

--
-- TOC entry 320 (class 1259 OID 2452431)
-- Name: fuc; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.fuc (
    fuc integer NOT NULL,
    fuc_desc character varying(80)
);


ALTER TABLE catalogo_objetos.fuc OWNER TO postgres;

--
-- TOC entry 321 (class 1259 OID 2452434)
-- Name: hct; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.hct (
    hct integer NOT NULL,
    hct_desc character varying(80)
);


ALTER TABLE catalogo_objetos.hct OWNER TO postgres;

--
-- TOC entry 322 (class 1259 OID 2452437)
-- Name: hyp; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.hyp (
    hyp integer NOT NULL,
    hyp_desc character varying(80)
);


ALTER TABLE catalogo_objetos.hyp OWNER TO postgres;

--
-- TOC entry 323 (class 1259 OID 2452440)
-- Name: kos; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.kos (
    kos integer NOT NULL,
    kos_desc character varying(80)
);


ALTER TABLE catalogo_objetos.kos OWNER TO postgres;

--
-- TOC entry 324 (class 1259 OID 2452443)
-- Name: loc; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.loc (
    loc integer NOT NULL,
    loc_desc character varying(80)
);


ALTER TABLE catalogo_objetos.loc OWNER TO postgres;

--
-- TOC entry 325 (class 1259 OID 2452446)
-- Name: mes; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.mes (
    mes integer NOT NULL,
    mes_desc character varying(80)
);


ALTER TABLE catalogo_objetos.mes OWNER TO postgres;

--
-- TOC entry 326 (class 1259 OID 2452449)
-- Name: rdt; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.rdt (
    rdt integer NOT NULL,
    rdt_desc character varying(80)
);


ALTER TABLE catalogo_objetos.rdt OWNER TO postgres;

--
-- TOC entry 327 (class 1259 OID 2452452)
-- Name: rel; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.rel (
    rel integer NOT NULL,
    rel_desc character varying(80)
);


ALTER TABLE catalogo_objetos.rel OWNER TO postgres;

--
-- TOC entry 328 (class 1259 OID 2452455)
-- Name: rgc; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.rgc (
    rgc integer NOT NULL,
    rgc_desc character varying(80)
);


ALTER TABLE catalogo_objetos.rgc OWNER TO postgres;

--
-- TOC entry 329 (class 1259 OID 2452458)
-- Name: rra; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.rra (
    rra integer NOT NULL,
    rra_desc character varying(80)
);


ALTER TABLE catalogo_objetos.rra OWNER TO postgres;

--
-- TOC entry 330 (class 1259 OID 2452461)
-- Name: rrc; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.rrc (
    rrc integer NOT NULL,
    rrc_desc character varying(80)
);


ALTER TABLE catalogo_objetos.rrc OWNER TO postgres;

--
-- TOC entry 331 (class 1259 OID 2452464)
-- Name: rst; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.rst (
    rst integer NOT NULL,
    rst_desc character varying(80)
);


ALTER TABLE catalogo_objetos.rst OWNER TO postgres;

--
-- TOC entry 332 (class 1259 OID 2452467)
-- Name: slt; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.slt (
    slt integer NOT NULL,
    slt_desc character varying(80)
);


ALTER TABLE catalogo_objetos.slt OWNER TO postgres;

--
-- TOC entry 333 (class 1259 OID 2452470)
-- Name: smc; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.smc (
    smc integer NOT NULL,
    smc_desc character varying(80)
);


ALTER TABLE catalogo_objetos.smc OWNER TO postgres;

--
-- TOC entry 334 (class 1259 OID 2452473)
-- Name: tra; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.tra (
    tra integer NOT NULL,
    tra_desc character varying(80)
);


ALTER TABLE catalogo_objetos.tra OWNER TO postgres;

--
-- TOC entry 335 (class 1259 OID 2452476)
-- Name: tuc; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.tuc (
    tuc integer NOT NULL,
    tuc_desc character varying(80)
);


ALTER TABLE catalogo_objetos.tuc OWNER TO postgres;

--
-- TOC entry 336 (class 1259 OID 2452479)
-- Name: typ; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.typ (
    typ integer NOT NULL,
    typ_desc character varying(80)
);


ALTER TABLE catalogo_objetos.typ OWNER TO postgres;

--
-- TOC entry 337 (class 1259 OID 2452482)
-- Name: uuc; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.uuc (
    uuc integer NOT NULL,
    uuc_desc character varying(80)
);


ALTER TABLE catalogo_objetos.uuc OWNER TO postgres;

--
-- TOC entry 338 (class 1259 OID 2452485)
-- Name: wtc; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.wtc (
    wtc integer NOT NULL,
    wtc_desc character varying(80)
);


ALTER TABLE catalogo_objetos.wtc OWNER TO postgres;

--
-- TOC entry 339 (class 1259 OID 2452488)
-- Name: wti; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.wti (
    wti integer NOT NULL,
    wti_desc character varying(80)
);


ALTER TABLE catalogo_objetos.wti OWNER TO postgres;

--
-- TOC entry 340 (class 1259 OID 2452491)
-- Name: punto_control_p; Type: TABLE; Schema: d_linderos_propiedad; Owner: postgres
--

CREATE TABLE d_linderos_propiedad.punto_control_p (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'ZB050'::character varying NOT NULL,
    acc integer NOT NULL,
    ela integer NOT NULL,
    zvh double precision,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'POINT'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32617)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'ZB050'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE d_linderos_propiedad.punto_control_p OWNER TO postgres;

--
-- TOC entry 7454 (class 0 OID 0)
-- Dependencies: 340
-- Name: TABLE punto_control_p; Type: COMMENT; Schema: d_linderos_propiedad; Owner: postgres
--

COMMENT ON TABLE d_linderos_propiedad.punto_control_p IS 'Objeto en el terreno de ubicación conocida, donde se ha determinado las coordenadas horizontal y/o vertical por métodos geodésicos o topográficos.';


--
-- TOC entry 341 (class 1259 OID 2452502)
-- Name: vertice_geodesico_p_gid_seq; Type: SEQUENCE; Schema: d_linderos_propiedad; Owner: postgres
--

CREATE SEQUENCE d_linderos_propiedad.vertice_geodesico_p_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE d_linderos_propiedad.vertice_geodesico_p_gid_seq OWNER TO postgres;

--
-- TOC entry 7455 (class 0 OID 0)
-- Dependencies: 341
-- Name: vertice_geodesico_p_gid_seq; Type: SEQUENCE OWNED BY; Schema: d_linderos_propiedad; Owner: postgres
--

ALTER SEQUENCE d_linderos_propiedad.vertice_geodesico_p_gid_seq OWNED BY d_linderos_propiedad.punto_control_p.gid;


--
-- TOC entry 342 (class 1259 OID 2452503)
-- Name: cementerio_a; Type: TABLE; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE TABLE gs_asociado_poblados.cementerio_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AL030'::character varying NOT NULL,
    nam character varying(80),
    rel integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32617)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AL030'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE gs_asociado_poblados.cementerio_a OWNER TO postgres;

--
-- TOC entry 7456 (class 0 OID 0)
-- Dependencies: 342
-- Name: TABLE cementerio_a; Type: COMMENT; Schema: gs_asociado_poblados; Owner: postgres
--

COMMENT ON TABLE gs_asociado_poblados.cementerio_a IS 'Sitio de estructuras asociadas, utilizadas para el entierro de muertos.';


--
-- TOC entry 343 (class 1259 OID 2452514)
-- Name: cementerio_a_gid_seq; Type: SEQUENCE; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE SEQUENCE gs_asociado_poblados.cementerio_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE gs_asociado_poblados.cementerio_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7457 (class 0 OID 0)
-- Dependencies: 343
-- Name: cementerio_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER SEQUENCE gs_asociado_poblados.cementerio_a_gid_seq OWNED BY gs_asociado_poblados.cementerio_a.gid;


--
-- TOC entry 344 (class 1259 OID 2452515)
-- Name: cerca_l; Type: TABLE; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE TABLE gs_asociado_poblados.cerca_l (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AL070'::character varying NOT NULL,
    fti integer NOT NULL,
    wti integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'LINESTRING'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32617)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AL070'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE gs_asociado_poblados.cerca_l OWNER TO postgres;

--
-- TOC entry 7458 (class 0 OID 0)
-- Dependencies: 344
-- Name: TABLE cerca_l; Type: COMMENT; Schema: gs_asociado_poblados; Owner: postgres
--

COMMENT ON TABLE gs_asociado_poblados.cerca_l IS 'Barrera artificial construida por el hombre, de estructura relativamente liviana y que es utilizada como cercado o límite.';


--
-- TOC entry 345 (class 1259 OID 2452526)
-- Name: cerca_l_gid_seq; Type: SEQUENCE; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE SEQUENCE gs_asociado_poblados.cerca_l_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE gs_asociado_poblados.cerca_l_gid_seq OWNER TO postgres;

--
-- TOC entry 7459 (class 0 OID 0)
-- Dependencies: 345
-- Name: cerca_l_gid_seq; Type: SEQUENCE OWNED BY; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER SEQUENCE gs_asociado_poblados.cerca_l_gid_seq OWNED BY gs_asociado_poblados.cerca_l.gid;


--
-- TOC entry 346 (class 1259 OID 2452527)
-- Name: escalinata_a; Type: TABLE; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE TABLE gs_asociado_poblados.escalinata_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AQ150'::character varying NOT NULL,
    smc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32617)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AQ150'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE gs_asociado_poblados.escalinata_a OWNER TO postgres;

--
-- TOC entry 7460 (class 0 OID 0)
-- Dependencies: 346
-- Name: TABLE escalinata_a; Type: COMMENT; Schema: gs_asociado_poblados; Owner: postgres
--

COMMENT ON TABLE gs_asociado_poblados.escalinata_a IS 'Serie de escalones que sirven para subir a un plano más elevado o para bajar a un plano inferior. Para fines catastrales se levantarán únicamente las escalinatas públicas que permitan identificar el lindero de un predio.';


--
-- TOC entry 347 (class 1259 OID 2452538)
-- Name: escalinata_a_gid_seq; Type: SEQUENCE; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE SEQUENCE gs_asociado_poblados.escalinata_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE gs_asociado_poblados.escalinata_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7461 (class 0 OID 0)
-- Dependencies: 347
-- Name: escalinata_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER SEQUENCE gs_asociado_poblados.escalinata_a_gid_seq OWNED BY gs_asociado_poblados.escalinata_a.gid;


--
-- TOC entry 348 (class 1259 OID 2452539)
-- Name: muro_l; Type: TABLE; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE TABLE gs_asociado_poblados.muro_l (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AL260'::character varying NOT NULL,
    wti integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'LINESTRING'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32617)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AL260'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE gs_asociado_poblados.muro_l OWNER TO postgres;

--
-- TOC entry 7462 (class 0 OID 0)
-- Dependencies: 348
-- Name: TABLE muro_l; Type: COMMENT; Schema: gs_asociado_poblados; Owner: postgres
--

COMMENT ON TABLE gs_asociado_poblados.muro_l IS 'Barrera hecha por el hombre de material resistente y que es utilizado como límite o para protección. Es aquel objeto que permite identificar el lindero de un predio.';


--
-- TOC entry 349 (class 1259 OID 2452550)
-- Name: muro_l_gid_seq; Type: SEQUENCE; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE SEQUENCE gs_asociado_poblados.muro_l_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE gs_asociado_poblados.muro_l_gid_seq OWNER TO postgres;

--
-- TOC entry 7463 (class 0 OID 0)
-- Dependencies: 349
-- Name: muro_l_gid_seq; Type: SEQUENCE OWNED BY; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER SEQUENCE gs_asociado_poblados.muro_l_gid_seq OWNED BY gs_asociado_poblados.muro_l.gid;


--
-- TOC entry 350 (class 1259 OID 2452551)
-- Name: plaza_publica_a; Type: TABLE; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE TABLE gs_asociado_poblados.plaza_publica_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AL170'::character varying NOT NULL,
    nam character varying(80),
    smc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32617)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AL170'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE gs_asociado_poblados.plaza_publica_a OWNER TO postgres;

--
-- TOC entry 7464 (class 0 OID 0)
-- Dependencies: 350
-- Name: TABLE plaza_publica_a; Type: COMMENT; Schema: gs_asociado_poblados; Owner: postgres
--

COMMENT ON TABLE gs_asociado_poblados.plaza_publica_a IS 'Sitio abierto que sirve como lugar de reunión pública, en una zona poblada para diversos usos.';


--
-- TOC entry 351 (class 1259 OID 2452562)
-- Name: plaza_publica_a_gid_seq; Type: SEQUENCE; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE SEQUENCE gs_asociado_poblados.plaza_publica_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE gs_asociado_poblados.plaza_publica_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7465 (class 0 OID 0)
-- Dependencies: 351
-- Name: plaza_publica_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER SEQUENCE gs_asociado_poblados.plaza_publica_a_gid_seq OWNED BY gs_asociado_poblados.plaza_publica_a.gid;


--
-- TOC entry 352 (class 1259 OID 2452563)
-- Name: edificio_a; Type: TABLE; Schema: gs_construcciones; Owner: postgres
--

CREATE TABLE gs_construcciones.edificio_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AL015'::character varying NOT NULL,
    nam character varying(200),
    acc integer NOT NULL,
    uuc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32617)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AL015'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE gs_construcciones.edificio_a OWNER TO postgres;

--
-- TOC entry 7466 (class 0 OID 0)
-- Dependencies: 352
-- Name: TABLE edificio_a; Type: COMMENT; Schema: gs_construcciones; Owner: postgres
--

COMMENT ON TABLE gs_construcciones.edificio_a IS 'Construcción independiente, techada, generalmente con paredes; destinada al hábitat y/o actividades de personas. Para fines catastrales se incluye choza, misma que deberá ser catalogada en el atributo txt como "Choza".';


--
-- TOC entry 353 (class 1259 OID 2452574)
-- Name: edificio_a_gid_seq; Type: SEQUENCE; Schema: gs_construcciones; Owner: postgres
--

CREATE SEQUENCE gs_construcciones.edificio_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE gs_construcciones.edificio_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7467 (class 0 OID 0)
-- Dependencies: 353
-- Name: edificio_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: gs_construcciones; Owner: postgres
--

ALTER SEQUENCE gs_construcciones.edificio_a_gid_seq OWNED BY gs_construcciones.edificio_a.gid;


--
-- TOC entry 354 (class 1259 OID 2452575)
-- Name: cancha_a; Type: TABLE; Schema: gs_recreacion; Owner: postgres
--

CREATE TABLE gs_recreacion.cancha_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AK040'::character varying NOT NULL,
    nam character varying(80),
    smc integer NOT NULL,
    kos integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32617)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AK040'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE gs_recreacion.cancha_a OWNER TO postgres;

--
-- TOC entry 7468 (class 0 OID 0)
-- Dependencies: 354
-- Name: TABLE cancha_a; Type: COMMENT; Schema: gs_recreacion; Owner: postgres
--

COMMENT ON TABLE gs_recreacion.cancha_a IS 'Lugar al aire libre destinado a eventos deportivos, ejercicio o juegos.';


--
-- TOC entry 355 (class 1259 OID 2452586)
-- Name: cancha_a_gid_seq; Type: SEQUENCE; Schema: gs_recreacion; Owner: postgres
--

CREATE SEQUENCE gs_recreacion.cancha_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE gs_recreacion.cancha_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7469 (class 0 OID 0)
-- Dependencies: 355
-- Name: cancha_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: gs_recreacion; Owner: postgres
--

ALTER SEQUENCE gs_recreacion.cancha_a_gid_seq OWNED BY gs_recreacion.cancha_a.gid;


--
-- TOC entry 356 (class 1259 OID 2452587)
-- Name: estadio_a; Type: TABLE; Schema: gs_recreacion; Owner: postgres
--

CREATE TABLE gs_recreacion.estadio_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AK165'::character varying NOT NULL,
    nam character varying(80),
    acc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32617)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AK165'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE gs_recreacion.estadio_a OWNER TO postgres;

--
-- TOC entry 7470 (class 0 OID 0)
-- Dependencies: 356
-- Name: TABLE estadio_a; Type: COMMENT; Schema: gs_recreacion; Owner: postgres
--

COMMENT ON TABLE gs_recreacion.estadio_a IS 'Campo deportivo parcial o totalmente rodeado por una estructura diseñada para permitir a los espectadores ver un evento de pie o sentados; a menudo diseñados en forma y tamaño para dar cabida a deportes específicos (por ejemplo: el fútbol).';


--
-- TOC entry 357 (class 1259 OID 2452598)
-- Name: estadio_a_gid_seq; Type: SEQUENCE; Schema: gs_recreacion; Owner: postgres
--

CREATE SEQUENCE gs_recreacion.estadio_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE gs_recreacion.estadio_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7471 (class 0 OID 0)
-- Dependencies: 357
-- Name: estadio_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: gs_recreacion; Owner: postgres
--

ALTER SEQUENCE gs_recreacion.estadio_a_gid_seq OWNED BY gs_recreacion.estadio_a.gid;


--
-- TOC entry 358 (class 1259 OID 2452599)
-- Name: parque_a; Type: TABLE; Schema: gs_recreacion; Owner: postgres
--

CREATE TABLE gs_recreacion.parque_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AK120'::character varying NOT NULL,
    nam character varying(80),
    fuc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32617)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AK120'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE gs_recreacion.parque_a OWNER TO postgres;

--
-- TOC entry 7472 (class 0 OID 0)
-- Dependencies: 358
-- Name: TABLE parque_a; Type: COMMENT; Schema: gs_recreacion; Owner: postgres
--

COMMENT ON TABLE gs_recreacion.parque_a IS 'Área utilizada con propósitos recreacionales u ornamentales.';


--
-- TOC entry 359 (class 1259 OID 2452610)
-- Name: parque_a_gid_seq; Type: SEQUENCE; Schema: gs_recreacion; Owner: postgres
--

CREATE SEQUENCE gs_recreacion.parque_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE gs_recreacion.parque_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7473 (class 0 OID 0)
-- Dependencies: 359
-- Name: parque_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: gs_recreacion; Owner: postgres
--

ALTER SEQUENCE gs_recreacion.parque_a_gid_seq OWNED BY gs_recreacion.parque_a.gid;


--
-- TOC entry 360 (class 1259 OID 2452611)
-- Name: piscina_a; Type: TABLE; Schema: gs_recreacion; Owner: postgres
--

CREATE TABLE gs_recreacion.piscina_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AK170'::character varying NOT NULL,
    nam character varying(80),
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32617)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AK170'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE gs_recreacion.piscina_a OWNER TO postgres;

--
-- TOC entry 7474 (class 0 OID 0)
-- Dependencies: 360
-- Name: TABLE piscina_a; Type: COMMENT; Schema: gs_recreacion; Owner: postgres
--

COMMENT ON TABLE gs_recreacion.piscina_a IS 'Construcción destinada a contener agua con fines de recreación y natación.';


--
-- TOC entry 361 (class 1259 OID 2452622)
-- Name: piscina_a_gid_seq; Type: SEQUENCE; Schema: gs_recreacion; Owner: postgres
--

CREATE SEQUENCE gs_recreacion.piscina_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE gs_recreacion.piscina_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7475 (class 0 OID 0)
-- Dependencies: 361
-- Name: piscina_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: gs_recreacion; Owner: postgres
--

ALTER SEQUENCE gs_recreacion.piscina_a_gid_seq OWNED BY gs_recreacion.piscina_a.gid;


--
-- TOC entry 362 (class 1259 OID 2452623)
-- Name: plaza_toros_a; Type: TABLE; Schema: gs_recreacion; Owner: postgres
--

CREATE TABLE gs_recreacion.plaza_toros_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AK166'::character varying NOT NULL,
    nam character varying(80),
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32617)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AK166'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE gs_recreacion.plaza_toros_a OWNER TO postgres;

--
-- TOC entry 7476 (class 0 OID 0)
-- Dependencies: 362
-- Name: TABLE plaza_toros_a; Type: COMMENT; Schema: gs_recreacion; Owner: postgres
--

COMMENT ON TABLE gs_recreacion.plaza_toros_a IS 'Construcción generalmente circular u ovalada, de cielo abierto, rodeada por graderíos para los espectadores.';


--
-- TOC entry 363 (class 1259 OID 2452634)
-- Name: plaza_toros_a_gid_seq; Type: SEQUENCE; Schema: gs_recreacion; Owner: postgres
--

CREATE SEQUENCE gs_recreacion.plaza_toros_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE gs_recreacion.plaza_toros_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7477 (class 0 OID 0)
-- Dependencies: 363
-- Name: plaza_toros_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: gs_recreacion; Owner: postgres
--

ALTER SEQUENCE gs_recreacion.plaza_toros_a_gid_seq OWNED BY gs_recreacion.plaza_toros_a.gid;


--
-- TOC entry 364 (class 1259 OID 2452635)
-- Name: acequia_l; Type: TABLE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE TABLE ho_aguas_interiores.acequia_l (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'BH030'::character varying NOT NULL,
    hyp integer NOT NULL,
    dit integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'LINESTRING'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32617)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'BH030'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE ho_aguas_interiores.acequia_l OWNER TO postgres;

--
-- TOC entry 7478 (class 0 OID 0)
-- Dependencies: 364
-- Name: TABLE acequia_l; Type: COMMENT; Schema: ho_aguas_interiores; Owner: postgres
--

COMMENT ON TABLE ho_aguas_interiores.acequia_l IS 'Excavación poco profunda construida en tierra con propósitos de drenaje o irrigación. Se debe levantar los dos lados de la acequia, no únicamente el eje. ';


--
-- TOC entry 365 (class 1259 OID 2452646)
-- Name: acequia_l_gid_seq; Type: SEQUENCE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE SEQUENCE ho_aguas_interiores.acequia_l_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ho_aguas_interiores.acequia_l_gid_seq OWNER TO postgres;

--
-- TOC entry 7479 (class 0 OID 0)
-- Dependencies: 365
-- Name: acequia_l_gid_seq; Type: SEQUENCE OWNED BY; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER SEQUENCE ho_aguas_interiores.acequia_l_gid_seq OWNED BY ho_aguas_interiores.acequia_l.gid;


--
-- TOC entry 366 (class 1259 OID 2452647)
-- Name: acueducto_canal_a; Type: TABLE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE TABLE ho_aguas_interiores.acueducto_canal_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'BH010'::character varying NOT NULL,
    atc integer NOT NULL,
    smc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32617)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'BH010'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE ho_aguas_interiores.acueducto_canal_a OWNER TO postgres;

--
-- TOC entry 7480 (class 0 OID 0)
-- Dependencies: 366
-- Name: TABLE acueducto_canal_a; Type: COMMENT; Schema: ho_aguas_interiores; Owner: postgres
--

COMMENT ON TABLE ho_aguas_interiores.acueducto_canal_a IS 'Cauce artificial que transporta agua en forma de flujo continuo desde un lugar en el que ésta es accesible para consumo u otros usos. ';


--
-- TOC entry 367 (class 1259 OID 2452658)
-- Name: acueducto_canal_a_gid_seq; Type: SEQUENCE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE SEQUENCE ho_aguas_interiores.acueducto_canal_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ho_aguas_interiores.acueducto_canal_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7481 (class 0 OID 0)
-- Dependencies: 367
-- Name: acueducto_canal_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER SEQUENCE ho_aguas_interiores.acueducto_canal_a_gid_seq OWNED BY ho_aguas_interiores.acueducto_canal_a.gid;


--
-- TOC entry 368 (class 1259 OID 2452659)
-- Name: lago_laguna_a; Type: TABLE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE TABLE ho_aguas_interiores.lago_laguna_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'BH080'::character varying NOT NULL,
    nam character varying(80),
    na2 character varying(80),
    hyp integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32617)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'BH080'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE ho_aguas_interiores.lago_laguna_a OWNER TO postgres;

--
-- TOC entry 7482 (class 0 OID 0)
-- Dependencies: 368
-- Name: TABLE lago_laguna_a; Type: COMMENT; Schema: ho_aguas_interiores; Owner: postgres
--

COMMENT ON TABLE ho_aguas_interiores.lago_laguna_a IS 'Cuerpo de agua, dulce o salada que se encuentra rodeada por tierra.';


--
-- TOC entry 369 (class 1259 OID 2452670)
-- Name: lago_laguna_a_gid_seq; Type: SEQUENCE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE SEQUENCE ho_aguas_interiores.lago_laguna_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ho_aguas_interiores.lago_laguna_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7483 (class 0 OID 0)
-- Dependencies: 369
-- Name: lago_laguna_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER SEQUENCE ho_aguas_interiores.lago_laguna_a_gid_seq OWNED BY ho_aguas_interiores.lago_laguna_a.gid;


--
-- TOC entry 370 (class 1259 OID 2452671)
-- Name: rio_a; Type: TABLE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE TABLE ho_aguas_interiores.rio_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'BH140'::character varying NOT NULL,
    nam character varying(100),
    na2 character varying(80),
    acc integer NOT NULL,
    hyp integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32617)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'BH140'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE ho_aguas_interiores.rio_a OWNER TO postgres;

--
-- TOC entry 7484 (class 0 OID 0)
-- Dependencies: 370
-- Name: TABLE rio_a; Type: COMMENT; Schema: ho_aguas_interiores; Owner: postgres
--

COMMENT ON TABLE ho_aguas_interiores.rio_a IS 'Curso de agua que fluye naturalmente.';


--
-- TOC entry 371 (class 1259 OID 2452682)
-- Name: rio_a_gid_seq; Type: SEQUENCE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE SEQUENCE ho_aguas_interiores.rio_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ho_aguas_interiores.rio_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7485 (class 0 OID 0)
-- Dependencies: 371
-- Name: rio_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER SEQUENCE ho_aguas_interiores.rio_a_gid_seq OWNED BY ho_aguas_interiores.rio_a.gid;


--
-- TOC entry 372 (class 1259 OID 2452683)
-- Name: rio_l; Type: TABLE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE TABLE ho_aguas_interiores.rio_l (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'BH140'::character varying NOT NULL,
    nam character varying(100),
    na2 character varying(80),
    acc integer NOT NULL,
    hyp integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'LINESTRING'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32617)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'BH140'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE ho_aguas_interiores.rio_l OWNER TO postgres;

--
-- TOC entry 7486 (class 0 OID 0)
-- Dependencies: 372
-- Name: TABLE rio_l; Type: COMMENT; Schema: ho_aguas_interiores; Owner: postgres
--

COMMENT ON TABLE ho_aguas_interiores.rio_l IS 'Curso de agua que fluye naturalmente.';


--
-- TOC entry 373 (class 1259 OID 2452694)
-- Name: rio_l_gid_seq; Type: SEQUENCE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE SEQUENCE ho_aguas_interiores.rio_l_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ho_aguas_interiores.rio_l_gid_seq OWNER TO postgres;

--
-- TOC entry 7487 (class 0 OID 0)
-- Dependencies: 373
-- Name: rio_l_gid_seq; Type: SEQUENCE OWNED BY; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER SEQUENCE ho_aguas_interiores.rio_l_gid_seq OWNED BY ho_aguas_interiores.rio_l.gid;


--
-- TOC entry 374 (class 1259 OID 2452695)
-- Name: zanja_l; Type: TABLE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE TABLE ho_aguas_interiores.zanja_l (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'BH100'::character varying NOT NULL,
    hyp integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'LINESTRING'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32617)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'BH100'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE ho_aguas_interiores.zanja_l OWNER TO postgres;

--
-- TOC entry 7488 (class 0 OID 0)
-- Dependencies: 374
-- Name: TABLE zanja_l; Type: COMMENT; Schema: ho_aguas_interiores; Owner: postgres
--

COMMENT ON TABLE ho_aguas_interiores.zanja_l IS 'Excavación larga y estrecha que se hace en la tierra para echar los cimientos, conducir las aguas, defender los sembríos o usos semejantes. Se debe levantar los dos lados de la zanja, no únicamente el eje. ';


--
-- TOC entry 375 (class 1259 OID 2452706)
-- Name: zanja_l_gid_seq; Type: SEQUENCE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE SEQUENCE ho_aguas_interiores.zanja_l_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ho_aguas_interiores.zanja_l_gid_seq OWNER TO postgres;

--
-- TOC entry 7489 (class 0 OID 0)
-- Dependencies: 375
-- Name: zanja_l_gid_seq; Type: SEQUENCE OWNED BY; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER SEQUENCE ho_aguas_interiores.zanja_l_gid_seq OWNED BY ho_aguas_interiores.zanja_l.gid;


--
-- TOC entry 376 (class 1259 OID 2452707)
-- Name: puerto_a; Type: TABLE; Schema: ho_puertos_muelles; Owner: postgres
--

CREATE TABLE ho_puertos_muelles.puerto_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'BB005'::character varying NOT NULL,
    nam character varying(80),
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32617)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'BB005'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE ho_puertos_muelles.puerto_a OWNER TO postgres;

--
-- TOC entry 7490 (class 0 OID 0)
-- Dependencies: 376
-- Name: TABLE puerto_a; Type: COMMENT; Schema: ho_puertos_muelles; Owner: postgres
--

COMMENT ON TABLE ho_puertos_muelles.puerto_a IS 'Conjunto de obras, instalaciones y servicios que proporcionan el espacio necesario para la estancia de los buques mientras realizan operaciones de carga, descarga, almacenaje y tránsito de pasajeros.';


--
-- TOC entry 377 (class 1259 OID 2452718)
-- Name: puerto_a_gid_seq; Type: SEQUENCE; Schema: ho_puertos_muelles; Owner: postgres
--

CREATE SEQUENCE ho_puertos_muelles.puerto_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ho_puertos_muelles.puerto_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7491 (class 0 OID 0)
-- Dependencies: 377
-- Name: puerto_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: ho_puertos_muelles; Owner: postgres
--

ALTER SEQUENCE ho_puertos_muelles.puerto_a_gid_seq OWNED BY ho_puertos_muelles.puerto_a.gid;


--
-- TOC entry 378 (class 1259 OID 2452719)
-- Name: granja_acuatica_a; Type: TABLE; Schema: ho_regulacion_zonas_restringidas; Owner: postgres
--

CREATE TABLE ho_regulacion_zonas_restringidas.granja_acuatica_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'BH050'::character varying NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32617)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'BH050'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE ho_regulacion_zonas_restringidas.granja_acuatica_a OWNER TO postgres;

--
-- TOC entry 7492 (class 0 OID 0)
-- Dependencies: 378
-- Name: TABLE granja_acuatica_a; Type: COMMENT; Schema: ho_regulacion_zonas_restringidas; Owner: postgres
--

COMMENT ON TABLE ho_regulacion_zonas_restringidas.granja_acuatica_a IS 'Área cerrada de agua utilizada para la reproducción o cría de camarones, peces y similares. ';


--
-- TOC entry 379 (class 1259 OID 2452730)
-- Name: granja_acuatica_a_gid_seq; Type: SEQUENCE; Schema: ho_regulacion_zonas_restringidas; Owner: postgres
--

CREATE SEQUENCE ho_regulacion_zonas_restringidas.granja_acuatica_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ho_regulacion_zonas_restringidas.granja_acuatica_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7493 (class 0 OID 0)
-- Dependencies: 379
-- Name: granja_acuatica_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: ho_regulacion_zonas_restringidas; Owner: postgres
--

ALTER SEQUENCE ho_regulacion_zonas_restringidas.granja_acuatica_a_gid_seq OWNED BY ho_regulacion_zonas_restringidas.granja_acuatica_a.gid;


--
-- TOC entry 380 (class 1259 OID 2452731)
-- Name: isla_a; Type: TABLE; Schema: ho_zonas_costeras; Owner: postgres
--

CREATE TABLE ho_zonas_costeras.isla_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'BA030'::character varying NOT NULL,
    nam character varying(80),
    na2 character varying(80),
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32617)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'BA030'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE ho_zonas_costeras.isla_a OWNER TO postgres;

--
-- TOC entry 7494 (class 0 OID 0)
-- Dependencies: 380
-- Name: TABLE isla_a; Type: COMMENT; Schema: ho_zonas_costeras; Owner: postgres
--

COMMENT ON TABLE ho_zonas_costeras.isla_a IS 'Masa de tierra más pequeña que un continente y que está rodeada por agua.';


--
-- TOC entry 381 (class 1259 OID 2452742)
-- Name: isla_a_gid_seq; Type: SEQUENCE; Schema: ho_zonas_costeras; Owner: postgres
--

CREATE SEQUENCE ho_zonas_costeras.isla_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ho_zonas_costeras.isla_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7495 (class 0 OID 0)
-- Dependencies: 381
-- Name: isla_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: ho_zonas_costeras; Owner: postgres
--

ALTER SEQUENCE ho_zonas_costeras.isla_a_gid_seq OWNED BY ho_zonas_costeras.isla_a.gid;


--
-- TOC entry 382 (class 1259 OID 2452743)
-- Name: orilla_l; Type: TABLE; Schema: ho_zonas_costeras; Owner: postgres
--

CREATE TABLE ho_zonas_costeras.orilla_l (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'BA010'::character varying NOT NULL,
    acc integer NOT NULL,
    slt integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'LINESTRING'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32617)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'BA010'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE ho_zonas_costeras.orilla_l OWNER TO postgres;

--
-- TOC entry 7496 (class 0 OID 0)
-- Dependencies: 382
-- Name: TABLE orilla_l; Type: COMMENT; Schema: ho_zonas_costeras; Owner: postgres
--

COMMENT ON TABLE ho_zonas_costeras.orilla_l IS 'Línea donde una superficie está en contacto con un cuerpo de agua. ';


--
-- TOC entry 383 (class 1259 OID 2452754)
-- Name: orilla_l_gid_seq; Type: SEQUENCE; Schema: ho_zonas_costeras; Owner: postgres
--

CREATE SEQUENCE ho_zonas_costeras.orilla_l_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ho_zonas_costeras.orilla_l_gid_seq OWNER TO postgres;

--
-- TOC entry 7497 (class 0 OID 0)
-- Dependencies: 383
-- Name: orilla_l_gid_seq; Type: SEQUENCE OWNED BY; Schema: ho_zonas_costeras; Owner: postgres
--

ALTER SEQUENCE ho_zonas_costeras.orilla_l_gid_seq OWNED BY ho_zonas_costeras.orilla_l.gid;


--
-- TOC entry 384 (class 1259 OID 2452755)
-- Name: invernadero_a; Type: TABLE; Schema: ii_agropecuaria; Owner: postgres
--

CREATE TABLE ii_agropecuaria.invernadero_a (
    gid integer DEFAULT nextval(('ii_agropecuaria.invernadero_a_gid_seq'::text)::regclass) NOT NULL,
    fcode character varying(5) DEFAULT 'AJ110'::character varying NOT NULL,
    nam character varying(80),
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32617)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AJ110'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE ii_agropecuaria.invernadero_a OWNER TO postgres;

--
-- TOC entry 7498 (class 0 OID 0)
-- Dependencies: 384
-- Name: TABLE invernadero_a; Type: COMMENT; Schema: ii_agropecuaria; Owner: postgres
--

COMMENT ON TABLE ii_agropecuaria.invernadero_a IS 'Edificio construido principalmente de material transparente en el que la temperatura y la humedad puede ser controlada para el cultivo y/o protección de plantas.';


--
-- TOC entry 385 (class 1259 OID 2452767)
-- Name: invernadero_a_gid_seq; Type: SEQUENCE; Schema: ii_agropecuaria; Owner: postgres
--

CREATE SEQUENCE ii_agropecuaria.invernadero_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ii_agropecuaria.invernadero_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7499 (class 0 OID 0)
-- Dependencies: 385
-- Name: invernadero_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: ii_agropecuaria; Owner: postgres
--

ALTER SEQUENCE ii_agropecuaria.invernadero_a_gid_seq OWNED BY ii_agropecuaria.invernadero_a.gid;


--
-- TOC entry 386 (class 1259 OID 2452768)
-- Name: acera_a; Type: TABLE; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE TABLE it_asociado_transportacion.acera_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AQ035'::character varying NOT NULL,
    smc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32617)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AQ035'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE it_asociado_transportacion.acera_a OWNER TO postgres;

--
-- TOC entry 7500 (class 0 OID 0)
-- Dependencies: 386
-- Name: TABLE acera_a; Type: COMMENT; Schema: it_asociado_transportacion; Owner: postgres
--

COMMENT ON TABLE it_asociado_transportacion.acera_a IS 'Ruta pavimentada o mejorada para uso del peatón, normalmente se encuentra adyacente y paralela a una calle o carretera. ';


--
-- TOC entry 387 (class 1259 OID 2452779)
-- Name: acera_a_gid_seq; Type: SEQUENCE; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE SEQUENCE it_asociado_transportacion.acera_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE it_asociado_transportacion.acera_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7501 (class 0 OID 0)
-- Dependencies: 387
-- Name: acera_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER SEQUENCE it_asociado_transportacion.acera_a_gid_seq OWNED BY it_asociado_transportacion.acera_a.gid;


--
-- TOC entry 388 (class 1259 OID 2452780)
-- Name: bordillo_l; Type: TABLE; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE TABLE it_asociado_transportacion.bordillo_l (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AQ037'::character varying NOT NULL,
    smc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'LINESTRING'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32617)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AQ037'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE it_asociado_transportacion.bordillo_l OWNER TO postgres;

--
-- TOC entry 7502 (class 0 OID 0)
-- Dependencies: 388
-- Name: TABLE bordillo_l; Type: COMMENT; Schema: it_asociado_transportacion; Owner: postgres
--

COMMENT ON TABLE it_asociado_transportacion.bordillo_l IS 'Borde de hormigón, asfalto o piedras que forman el borde de una acera a lo largo de la orilla de una calle o carretera. Se debe incluir aquellos que formen parte de los parterres.';


--
-- TOC entry 389 (class 1259 OID 2452791)
-- Name: bordillo_l_gid_seq; Type: SEQUENCE; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE SEQUENCE it_asociado_transportacion.bordillo_l_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE it_asociado_transportacion.bordillo_l_gid_seq OWNER TO postgres;

--
-- TOC entry 7503 (class 0 OID 0)
-- Dependencies: 389
-- Name: bordillo_l_gid_seq; Type: SEQUENCE OWNED BY; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER SEQUENCE it_asociado_transportacion.bordillo_l_gid_seq OWNED BY it_asociado_transportacion.bordillo_l.gid;


--
-- TOC entry 390 (class 1259 OID 2452792)
-- Name: cuneta_a; Type: TABLE; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE TABLE it_asociado_transportacion.cuneta_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AQ036'::character varying NOT NULL,
    smc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry(MultiPolygon,32617) NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32617)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AQ036'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE it_asociado_transportacion.cuneta_a OWNER TO postgres;

--
-- TOC entry 7504 (class 0 OID 0)
-- Dependencies: 390
-- Name: TABLE cuneta_a; Type: COMMENT; Schema: it_asociado_transportacion; Owner: postgres
--

COMMENT ON TABLE it_asociado_transportacion.cuneta_a IS 'Borde de hormigón, asfalto o piedras que forman parte de un canal a lo largo del borde de una calle o carretera. Este objeto tiene el fin de canalizar agua de lluvia que se escurra a lo largo de la vía.';


--
-- TOC entry 391 (class 1259 OID 2452803)
-- Name: cuneta_a_gid_seq; Type: SEQUENCE; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE SEQUENCE it_asociado_transportacion.cuneta_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE it_asociado_transportacion.cuneta_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7505 (class 0 OID 0)
-- Dependencies: 391
-- Name: cuneta_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER SEQUENCE it_asociado_transportacion.cuneta_a_gid_seq OWNED BY it_asociado_transportacion.cuneta_a.gid;


--
-- TOC entry 392 (class 1259 OID 2452804)
-- Name: parqueadero_a; Type: TABLE; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE TABLE it_asociado_transportacion.parqueadero_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AQ140'::character varying NOT NULL,
    nam character varying(80),
    smc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32617)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AQ140'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE it_asociado_transportacion.parqueadero_a OWNER TO postgres;

--
-- TOC entry 7506 (class 0 OID 0)
-- Dependencies: 392
-- Name: TABLE parqueadero_a; Type: COMMENT; Schema: it_asociado_transportacion; Owner: postgres
--

COMMENT ON TABLE it_asociado_transportacion.parqueadero_a IS 'Lugar destinado generalmente para estacionar vehículos.';


--
-- TOC entry 393 (class 1259 OID 2452815)
-- Name: parqueadero_a_gid_seq; Type: SEQUENCE; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE SEQUENCE it_asociado_transportacion.parqueadero_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE it_asociado_transportacion.parqueadero_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7507 (class 0 OID 0)
-- Dependencies: 393
-- Name: parqueadero_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER SEQUENCE it_asociado_transportacion.parqueadero_a_gid_seq OWNED BY it_asociado_transportacion.parqueadero_a.gid;


--
-- TOC entry 394 (class 1259 OID 2452816)
-- Name: paseo_peatonal_ciclovia_a; Type: TABLE; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE TABLE it_asociado_transportacion.paseo_peatonal_ciclovia_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AP031'::character varying NOT NULL,
    nam character varying(80),
    smc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32617)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AP031'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE it_asociado_transportacion.paseo_peatonal_ciclovia_a OWNER TO postgres;

--
-- TOC entry 7508 (class 0 OID 0)
-- Dependencies: 394
-- Name: TABLE paseo_peatonal_ciclovia_a; Type: COMMENT; Schema: it_asociado_transportacion; Owner: postgres
--

COMMENT ON TABLE it_asociado_transportacion.paseo_peatonal_ciclovia_a IS 'Franja de terreno pavimentada o mejorada que tiene por objeto servir como una vía para peatones, animales y/o vehículos no motorizado.';


--
-- TOC entry 395 (class 1259 OID 2452827)
-- Name: paseo_peatonal_ciclovia_a_gid_seq; Type: SEQUENCE; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE SEQUENCE it_asociado_transportacion.paseo_peatonal_ciclovia_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE it_asociado_transportacion.paseo_peatonal_ciclovia_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7509 (class 0 OID 0)
-- Dependencies: 395
-- Name: paseo_peatonal_ciclovia_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER SEQUENCE it_asociado_transportacion.paseo_peatonal_ciclovia_a_gid_seq OWNED BY it_asociado_transportacion.paseo_peatonal_ciclovia_a.gid;


--
-- TOC entry 396 (class 1259 OID 2452828)
-- Name: tunel_a; Type: TABLE; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE TABLE it_asociado_transportacion.tunel_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AQ130'::character varying NOT NULL,
    nam character varying(80),
    tra integer NOT NULL,
    tuc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry(MultiPolygon,32617) NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32617)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AQ130'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE it_asociado_transportacion.tunel_a OWNER TO postgres;

--
-- TOC entry 7510 (class 0 OID 0)
-- Dependencies: 396
-- Name: TABLE tunel_a; Type: COMMENT; Schema: it_asociado_transportacion; Owner: postgres
--

COMMENT ON TABLE it_asociado_transportacion.tunel_a IS 'Paso subterráneo o submarino, abierto para establecer comunicación.';


--
-- TOC entry 397 (class 1259 OID 2452839)
-- Name: tunel_a_gid_seq; Type: SEQUENCE; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE SEQUENCE it_asociado_transportacion.tunel_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE it_asociado_transportacion.tunel_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7511 (class 0 OID 0)
-- Dependencies: 397
-- Name: tunel_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER SEQUENCE it_asociado_transportacion.tunel_a_gid_seq OWNED BY it_asociado_transportacion.tunel_a.gid;


--
-- TOC entry 398 (class 1259 OID 2452840)
-- Name: puente_a; Type: TABLE; Schema: it_cruces_enlaces; Owner: postgres
--

CREATE TABLE it_cruces_enlaces.puente_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AQ040'::character varying NOT NULL,
    nam character varying(80),
    na2 character varying(80),
    acc integer NOT NULL,
    bsc integer NOT NULL,
    ltn integer NOT NULL,
    typ integer NOT NULL,
    tuc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32617)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AQ040'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE it_cruces_enlaces.puente_a OWNER TO postgres;

--
-- TOC entry 7512 (class 0 OID 0)
-- Dependencies: 398
-- Name: TABLE puente_a; Type: COMMENT; Schema: it_cruces_enlaces; Owner: postgres
--

COMMENT ON TABLE it_cruces_enlaces.puente_a IS 'Estructura que conecta dos lugares y facilita el paso de una ruta de transporte (por ejemplo: carretera o ferrocarril) sobre un obstáculo del terreno (por ejemplo: cuerpo de agua, barranco y/o carretera).';


--
-- TOC entry 399 (class 1259 OID 2452851)
-- Name: puente_a_gid_seq; Type: SEQUENCE; Schema: it_cruces_enlaces; Owner: postgres
--

CREATE SEQUENCE it_cruces_enlaces.puente_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE it_cruces_enlaces.puente_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7513 (class 0 OID 0)
-- Dependencies: 399
-- Name: puente_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: it_cruces_enlaces; Owner: postgres
--

ALTER SEQUENCE it_cruces_enlaces.puente_a_gid_seq OWNED BY it_cruces_enlaces.puente_a.gid;


--
-- TOC entry 400 (class 1259 OID 2452852)
-- Name: ferrocarril_a; Type: TABLE; Schema: it_ferrocarriles; Owner: postgres
--

CREATE TABLE it_ferrocarriles.ferrocarril_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AN010'::character varying NOT NULL,
    nam character varying(80),
    acc integer NOT NULL,
    fco integer NOT NULL,
    loc integer NOT NULL,
    ltn integer NOT NULL,
    rgc integer NOT NULL,
    rra integer NOT NULL,
    rrc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry(MultiPolygon,32617) NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32617)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AN010'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE it_ferrocarriles.ferrocarril_a OWNER TO postgres;

--
-- TOC entry 7514 (class 0 OID 0)
-- Dependencies: 400
-- Name: TABLE ferrocarril_a; Type: COMMENT; Schema: it_ferrocarriles; Owner: postgres
--

COMMENT ON TABLE it_ferrocarriles.ferrocarril_a IS 'Una o más vías de ferrocarril que comprende una red utilizada para el transporte de pasajeros y/o bienes.';


--
-- TOC entry 401 (class 1259 OID 2452863)
-- Name: ferrocarril_a_gid_seq; Type: SEQUENCE; Schema: it_ferrocarriles; Owner: postgres
--

CREATE SEQUENCE it_ferrocarriles.ferrocarril_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE it_ferrocarriles.ferrocarril_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7515 (class 0 OID 0)
-- Dependencies: 401
-- Name: ferrocarril_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: it_ferrocarriles; Owner: postgres
--

ALTER SEQUENCE it_ferrocarriles.ferrocarril_a_gid_seq OWNED BY it_ferrocarriles.ferrocarril_a.gid;


--
-- TOC entry 402 (class 1259 OID 2452864)
-- Name: gasolinera_a; Type: TABLE; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE TABLE it_transporte_terrestre.gasolinera_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AQ170'::character varying NOT NULL,
    nam character varying(80),
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32617)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AQ170'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE it_transporte_terrestre.gasolinera_a OWNER TO postgres;

--
-- TOC entry 7516 (class 0 OID 0)
-- Dependencies: 402
-- Name: TABLE gasolinera_a; Type: COMMENT; Schema: it_transporte_terrestre; Owner: postgres
--

COMMENT ON TABLE it_transporte_terrestre.gasolinera_a IS 'Establecimiento en el cual se vende combustible y lubricantes generalmente para vehículos de motor.';


--
-- TOC entry 403 (class 1259 OID 2452875)
-- Name: gasolinera_a_gid_seq; Type: SEQUENCE; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE SEQUENCE it_transporte_terrestre.gasolinera_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE it_transporte_terrestre.gasolinera_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7517 (class 0 OID 0)
-- Dependencies: 403
-- Name: gasolinera_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER SEQUENCE it_transporte_terrestre.gasolinera_a_gid_seq OWNED BY it_transporte_terrestre.gasolinera_a.gid;


--
-- TOC entry 404 (class 1259 OID 2452876)
-- Name: intercambiador_vial_a; Type: TABLE; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE TABLE it_transporte_terrestre.intercambiador_vial_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AP020'::character varying NOT NULL,
    nam character varying(80),
    hct integer NOT NULL,
    rst integer NOT NULL,
    loc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32617)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AP020'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE it_transporte_terrestre.intercambiador_vial_a OWNER TO postgres;

--
-- TOC entry 7518 (class 0 OID 0)
-- Dependencies: 404
-- Name: TABLE intercambiador_vial_a; Type: COMMENT; Schema: it_transporte_terrestre; Owner: postgres
--

COMMENT ON TABLE it_transporte_terrestre.intercambiador_vial_a IS 'Conexión diseñada para facilitar el acceso del tráfico de una carretera a otra.';


--
-- TOC entry 405 (class 1259 OID 2452887)
-- Name: intercambiador_vial_a_gid_seq; Type: SEQUENCE; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE SEQUENCE it_transporte_terrestre.intercambiador_vial_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE it_transporte_terrestre.intercambiador_vial_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7519 (class 0 OID 0)
-- Dependencies: 405
-- Name: intercambiador_vial_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER SEQUENCE it_transporte_terrestre.intercambiador_vial_a_gid_seq OWNED BY it_transporte_terrestre.intercambiador_vial_a.gid;


--
-- TOC entry 406 (class 1259 OID 2452888)
-- Name: rodera_l; Type: TABLE; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE TABLE it_transporte_terrestre.rodera_l (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AP010'::character varying NOT NULL,
    typ integer NOT NULL,
    rst integer NOT NULL,
    hct integer NOT NULL,
    rdt integer,
    wtc integer NOT NULL,
    ltn integer NOT NULL,
    tuc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'LINESTRING'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32617)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AP010'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE it_transporte_terrestre.rodera_l OWNER TO postgres;

--
-- TOC entry 7520 (class 0 OID 0)
-- Dependencies: 406
-- Name: TABLE rodera_l; Type: COMMENT; Schema: it_transporte_terrestre; Owner: postgres
--

COMMENT ON TABLE it_transporte_terrestre.rodera_l IS 'Vía natural con poca o ninguna mejora por la que pueden transitar vehículos de doble tracción.';


--
-- TOC entry 407 (class 1259 OID 2452899)
-- Name: rodera_l_gid_seq; Type: SEQUENCE; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE SEQUENCE it_transporte_terrestre.rodera_l_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE it_transporte_terrestre.rodera_l_gid_seq OWNER TO postgres;

--
-- TOC entry 7521 (class 0 OID 0)
-- Dependencies: 407
-- Name: rodera_l_gid_seq; Type: SEQUENCE OWNED BY; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER SEQUENCE it_transporte_terrestre.rodera_l_gid_seq OWNED BY it_transporte_terrestre.rodera_l.gid;


--
-- TOC entry 408 (class 1259 OID 2452900)
-- Name: sendero_l; Type: TABLE; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE TABLE it_transporte_terrestre.sendero_l (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AP050'::character varying NOT NULL,
    wtc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'LINESTRING'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32617)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AP050'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE it_transporte_terrestre.sendero_l OWNER TO postgres;

--
-- TOC entry 7522 (class 0 OID 0)
-- Dependencies: 408
-- Name: TABLE sendero_l; Type: COMMENT; Schema: it_transporte_terrestre; Owner: postgres
--

COMMENT ON TABLE it_transporte_terrestre.sendero_l IS 'Camino angosto abierto por el tránsito de personas o animales.';


--
-- TOC entry 409 (class 1259 OID 2452911)
-- Name: sendero_l_gid_seq; Type: SEQUENCE; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE SEQUENCE it_transporte_terrestre.sendero_l_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE it_transporte_terrestre.sendero_l_gid_seq OWNER TO postgres;

--
-- TOC entry 7523 (class 0 OID 0)
-- Dependencies: 409
-- Name: sendero_l_gid_seq; Type: SEQUENCE OWNED BY; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER SEQUENCE it_transporte_terrestre.sendero_l_gid_seq OWNED BY it_transporte_terrestre.sendero_l.gid;


--
-- TOC entry 410 (class 1259 OID 2452912)
-- Name: via_ruta_a; Type: TABLE; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE TABLE it_transporte_terrestre.via_ruta_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AP030'::character varying NOT NULL,
    nam character varying(80),
    na2 character varying(80),
    acc integer NOT NULL,
    rst integer NOT NULL,
    typ integer NOT NULL,
    hct integer NOT NULL,
    loc integer NOT NULL,
    ltn integer NOT NULL,
    mes integer NOT NULL,
    rdt integer,
    tuc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32617)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AP030'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE it_transporte_terrestre.via_ruta_a OWNER TO postgres;

--
-- TOC entry 7524 (class 0 OID 0)
-- Dependencies: 410
-- Name: TABLE via_ruta_a; Type: COMMENT; Schema: it_transporte_terrestre; Owner: postgres
--

COMMENT ON TABLE it_transporte_terrestre.via_ruta_a IS 'Trayecto con una superficie especialmente preparada que se mantiene para ser usada por vehículos generalmente a motor. ';


--
-- TOC entry 411 (class 1259 OID 2452923)
-- Name: via_ruta_a_gid_seq; Type: SEQUENCE; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE SEQUENCE it_transporte_terrestre.via_ruta_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE it_transporte_terrestre.via_ruta_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7525 (class 0 OID 0)
-- Dependencies: 411
-- Name: via_ruta_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER SEQUENCE it_transporte_terrestre.via_ruta_a_gid_seq OWNED BY it_transporte_terrestre.via_ruta_a.gid;


--
-- TOC entry 412 (class 1259 OID 2452924)
-- Name: qgis_projects; Type: TABLE; Schema: proyecto_qgis3; Owner: postgres
--

CREATE TABLE proyecto_qgis3.qgis_projects (
    name text NOT NULL,
    metadata jsonb,
    content bytea
);


ALTER TABLE proyecto_qgis3.qgis_projects OWNER TO postgres;

--
-- TOC entry 413 (class 1259 OID 2452929)
-- Name: acequia_l; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.acequia_l AS
 SELECT acequia_l.gid,
    acequia_l.fcode,
    catalogo_objetos.descripcion,
    hyp.hyp_desc,
    dit.dit_desc,
    acequia_l.txt,
    (acequia_l.the_geom)::public.geometry(LineString,32617) AS the_geom
   FROM (((ho_aguas_interiores.acequia_l
     JOIN catalogo_objetos.hyp ON ((acequia_l.hyp = hyp.hyp)))
     JOIN catalogo_objetos.dit ON ((acequia_l.dit = dit.dit)))
     JOIN catalogo_objetos.catalogo_objetos ON (((acequia_l.fcode)::text = (catalogo_objetos.fcode)::text)));


ALTER TABLE visualizacion.acequia_l OWNER TO postgres;

--
-- TOC entry 414 (class 1259 OID 2452934)
-- Name: acera_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.acera_a AS
 SELECT acera_a.gid,
    acera_a.fcode,
    catalogo_objetos.descripcion,
    smc.smc_desc,
    acera_a.txt,
    (acera_a.the_geom)::public.geometry(MultiPolygon,32617) AS the_geom
   FROM ((it_asociado_transportacion.acera_a
     JOIN catalogo_objetos.catalogo_objetos ON (((acera_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.smc ON ((acera_a.smc = smc.smc)));


ALTER TABLE visualizacion.acera_a OWNER TO postgres;

--
-- TOC entry 415 (class 1259 OID 2452939)
-- Name: acueducto_canal_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.acueducto_canal_a AS
 SELECT acueducto_canal_a.gid,
    acueducto_canal_a.fcode,
    catalogo_objetos.descripcion,
    atc.atc_desc,
    smc.smc_desc,
    acueducto_canal_a.txt,
    (acueducto_canal_a.the_geom)::public.geometry(MultiPolygon,32617) AS the_geom
   FROM (((ho_aguas_interiores.acueducto_canal_a
     JOIN catalogo_objetos.catalogo_objetos ON (((acueducto_canal_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.atc ON ((acueducto_canal_a.atc = atc.atc)))
     JOIN catalogo_objetos.smc ON ((acueducto_canal_a.smc = smc.smc)));


ALTER TABLE visualizacion.acueducto_canal_a OWNER TO postgres;

--
-- TOC entry 416 (class 1259 OID 2452944)
-- Name: aeropuerto_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.aeropuerto_a AS
 SELECT aeropuerto_a.gid,
    aeropuerto_a.fcode,
    catalogo_objetos.descripcion,
    aeropuerto_a.nam,
    acc.acc_desc,
    aeropuerto_a.iko,
    fuc.fuc_desc,
    aeropuerto_a.txt,
    (aeropuerto_a.the_geom)::public.geometry(MultiPolygon,32617) AS the_geom
   FROM (((a_aeropuerto_superficie.aeropuerto_a
     JOIN catalogo_objetos.catalogo_objetos ON (((aeropuerto_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.acc ON ((aeropuerto_a.acc = acc.acc)))
     JOIN catalogo_objetos.fuc ON ((aeropuerto_a.fuc = fuc.fuc)));


ALTER TABLE visualizacion.aeropuerto_a OWNER TO postgres;

--
-- TOC entry 417 (class 1259 OID 2452949)
-- Name: bordillo_l; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.bordillo_l AS
 SELECT bordillo_l.gid,
    bordillo_l.fcode,
    catalogo_objetos.descripcion,
    smc.smc_desc,
    bordillo_l.txt,
    (bordillo_l.the_geom)::public.geometry(LineString,32617) AS the_geom
   FROM ((it_asociado_transportacion.bordillo_l
     JOIN catalogo_objetos.catalogo_objetos ON (((bordillo_l.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.smc ON ((bordillo_l.smc = smc.smc)));


ALTER TABLE visualizacion.bordillo_l OWNER TO postgres;

--
-- TOC entry 418 (class 1259 OID 2452954)
-- Name: cancha_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.cancha_a AS
 SELECT cancha_a.gid,
    cancha_a.fcode,
    catalogo_objetos.descripcion,
    cancha_a.nam,
    smc.smc_desc,
    kos.kos_desc,
    cancha_a.txt,
    (cancha_a.the_geom)::public.geometry(MultiPolygon,32617) AS the_geom
   FROM (((gs_recreacion.cancha_a
     JOIN catalogo_objetos.catalogo_objetos ON (((cancha_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.smc ON ((cancha_a.smc = smc.smc)))
     JOIN catalogo_objetos.kos ON ((cancha_a.kos = kos.kos)));


ALTER TABLE visualizacion.cancha_a OWNER TO postgres;

--
-- TOC entry 419 (class 1259 OID 2452959)
-- Name: cementerio_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.cementerio_a AS
 SELECT cementerio_a.gid,
    cementerio_a.fcode,
    catalogo_objetos.descripcion,
    cementerio_a.nam,
    rel.rel_desc,
    cementerio_a.txt,
    (cementerio_a.the_geom)::public.geometry(MultiPolygon,32617) AS the_geom
   FROM ((gs_asociado_poblados.cementerio_a
     JOIN catalogo_objetos.catalogo_objetos ON (((cementerio_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.rel ON ((cementerio_a.rel = rel.rel)));


ALTER TABLE visualizacion.cementerio_a OWNER TO postgres;

--
-- TOC entry 420 (class 1259 OID 2452964)
-- Name: cerca_l; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.cerca_l AS
 SELECT cerca_l.gid,
    cerca_l.fcode,
    catalogo_objetos.descripcion,
    fti.fti_desc,
    wti.wti_desc,
    cerca_l.txt,
    (cerca_l.the_geom)::public.geometry(LineString,32617) AS the_geom
   FROM (((gs_asociado_poblados.cerca_l
     JOIN catalogo_objetos.catalogo_objetos ON (((cerca_l.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.fti ON ((cerca_l.fti = fti.fti)))
     JOIN catalogo_objetos.wti ON ((cerca_l.wti = wti.wti)));


ALTER TABLE visualizacion.cerca_l OWNER TO postgres;

--
-- TOC entry 421 (class 1259 OID 2452969)
-- Name: cuneta_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.cuneta_a AS
 SELECT cuneta_a.gid,
    cuneta_a.fcode,
    catalogo_objetos.descripcion,
    smc.smc_desc,
    cuneta_a.txt,
    cuneta_a.the_geom
   FROM ((it_asociado_transportacion.cuneta_a
     JOIN catalogo_objetos.catalogo_objetos ON (((cuneta_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.smc ON ((cuneta_a.smc = smc.smc)));


ALTER TABLE visualizacion.cuneta_a OWNER TO postgres;

--
-- TOC entry 422 (class 1259 OID 2452973)
-- Name: edificio_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.edificio_a AS
 SELECT edificio_a.gid,
    edificio_a.fcode,
    catalogo_objetos.descripcion,
    edificio_a.nam,
    acc.acc_desc,
    uuc.uuc_desc,
    edificio_a.txt,
    (edificio_a.the_geom)::public.geometry(MultiPolygon,32617) AS the_geom
   FROM (((gs_construcciones.edificio_a
     JOIN catalogo_objetos.catalogo_objetos ON (((edificio_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.acc ON ((edificio_a.acc = acc.acc)))
     JOIN catalogo_objetos.uuc ON ((edificio_a.uuc = uuc.uuc)));


ALTER TABLE visualizacion.edificio_a OWNER TO postgres;

--
-- TOC entry 423 (class 1259 OID 2452978)
-- Name: escalinata_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.escalinata_a AS
 SELECT escalinata_a.gid,
    escalinata_a.fcode,
    catalogo_objetos.descripcion,
    smc.smc_desc,
    escalinata_a.txt,
    (escalinata_a.the_geom)::public.geometry(MultiPolygon,32617) AS the_geom
   FROM ((gs_asociado_poblados.escalinata_a
     JOIN catalogo_objetos.catalogo_objetos ON (((escalinata_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.smc ON ((escalinata_a.smc = smc.smc)));


ALTER TABLE visualizacion.escalinata_a OWNER TO postgres;

--
-- TOC entry 424 (class 1259 OID 2452983)
-- Name: estadio_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.estadio_a AS
 SELECT estadio_a.gid,
    estadio_a.fcode,
    catalogo_objetos.descripcion,
    estadio_a.nam,
    acc.acc_desc,
    estadio_a.txt,
    (estadio_a.the_geom)::public.geometry(MultiPolygon,32617) AS the_geom
   FROM ((gs_recreacion.estadio_a
     JOIN catalogo_objetos.catalogo_objetos ON (((estadio_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.acc ON ((estadio_a.acc = acc.acc)));


ALTER TABLE visualizacion.estadio_a OWNER TO postgres;

--
-- TOC entry 425 (class 1259 OID 2452988)
-- Name: ferrocarril_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.ferrocarril_a AS
 SELECT ferrocarril_a.gid,
    ferrocarril_a.fcode,
    catalogo_objetos.descripcion,
    ferrocarril_a.nam,
    acc.acc_desc,
    fco.fco_desc,
    loc.loc_desc,
    ferrocarril_a.ltn,
    rgc.rgc_desc,
    rra.rra_desc,
    rrc.rrc_desc,
    ferrocarril_a.txt,
    ferrocarril_a.the_geom
   FROM (((((((it_ferrocarriles.ferrocarril_a
     JOIN catalogo_objetos.catalogo_objetos ON (((ferrocarril_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.acc ON ((ferrocarril_a.acc = acc.acc)))
     JOIN catalogo_objetos.fco ON ((ferrocarril_a.fco = fco.fco)))
     JOIN catalogo_objetos.loc ON ((ferrocarril_a.loc = loc.loc)))
     JOIN catalogo_objetos.rgc ON ((ferrocarril_a.rgc = rgc.rgc)))
     JOIN catalogo_objetos.rra ON ((ferrocarril_a.rra = rra.rra)))
     JOIN catalogo_objetos.rrc ON ((ferrocarril_a.rrc = rrc.rrc)));


ALTER TABLE visualizacion.ferrocarril_a OWNER TO postgres;

--
-- TOC entry 426 (class 1259 OID 2452993)
-- Name: gasolinera_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.gasolinera_a AS
 SELECT gasolinera_a.gid,
    gasolinera_a.fcode,
    catalogo_objetos.descripcion,
    gasolinera_a.nam,
    gasolinera_a.txt,
    (gasolinera_a.the_geom)::public.geometry(MultiPolygon,32617) AS the_geom
   FROM (it_transporte_terrestre.gasolinera_a
     JOIN catalogo_objetos.catalogo_objetos ON (((gasolinera_a.fcode)::text = (catalogo_objetos.fcode)::text)));


ALTER TABLE visualizacion.gasolinera_a OWNER TO postgres;

--
-- TOC entry 427 (class 1259 OID 2452997)
-- Name: granja_acuatica_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.granja_acuatica_a AS
 SELECT granja_acuatica_a.gid,
    granja_acuatica_a.fcode,
    catalogo_objetos.descripcion,
    granja_acuatica_a.txt,
    (granja_acuatica_a.the_geom)::public.geometry(MultiPolygon,32617) AS the_geom
   FROM (ho_regulacion_zonas_restringidas.granja_acuatica_a
     JOIN catalogo_objetos.catalogo_objetos ON (((granja_acuatica_a.fcode)::text = (catalogo_objetos.fcode)::text)));


ALTER TABLE visualizacion.granja_acuatica_a OWNER TO postgres;

--
-- TOC entry 428 (class 1259 OID 2453001)
-- Name: intercambiador_vial_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.intercambiador_vial_a AS
 SELECT intercambiador_vial_a.gid,
    intercambiador_vial_a.fcode,
    catalogo_objetos.descripcion,
    intercambiador_vial_a.nam,
    hct.hct_desc,
    rst.rst_desc,
    loc.loc_desc,
    intercambiador_vial_a.txt,
    (intercambiador_vial_a.the_geom)::public.geometry(MultiPolygon,32617) AS the_geom
   FROM ((((it_transporte_terrestre.intercambiador_vial_a
     JOIN catalogo_objetos.catalogo_objetos ON (((intercambiador_vial_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.hct ON ((intercambiador_vial_a.hct = hct.hct)))
     JOIN catalogo_objetos.rst ON ((intercambiador_vial_a.rst = rst.rst)))
     JOIN catalogo_objetos.loc ON ((intercambiador_vial_a.loc = loc.loc)));


ALTER TABLE visualizacion.intercambiador_vial_a OWNER TO postgres;

--
-- TOC entry 429 (class 1259 OID 2453006)
-- Name: invernadero_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.invernadero_a AS
 SELECT invernadero_a.gid,
    invernadero_a.fcode,
    catalogo_objetos.descripcion,
    invernadero_a.nam,
    invernadero_a.txt,
    (invernadero_a.the_geom)::public.geometry(MultiPolygon,32617) AS the_geom
   FROM (ii_agropecuaria.invernadero_a
     JOIN catalogo_objetos.catalogo_objetos ON (((invernadero_a.fcode)::text = (catalogo_objetos.fcode)::text)));


ALTER TABLE visualizacion.invernadero_a OWNER TO postgres;

--
-- TOC entry 430 (class 1259 OID 2453010)
-- Name: isla_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.isla_a AS
 SELECT isla_a.gid,
    isla_a.fcode,
    catalogo_objetos.descripcion,
    isla_a.nam,
    isla_a.na2,
    isla_a.txt,
    (isla_a.the_geom)::public.geometry(MultiPolygon,32617) AS the_geom
   FROM (ho_zonas_costeras.isla_a
     JOIN catalogo_objetos.catalogo_objetos ON (((isla_a.fcode)::text = (catalogo_objetos.fcode)::text)));


ALTER TABLE visualizacion.isla_a OWNER TO postgres;

--
-- TOC entry 431 (class 1259 OID 2453014)
-- Name: lago_laguna_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.lago_laguna_a AS
 SELECT lago_laguna_a.gid,
    lago_laguna_a.fcode,
    catalogo_objetos.descripcion,
    lago_laguna_a.nam,
    lago_laguna_a.na2,
    hyp.hyp_desc,
    lago_laguna_a.txt,
    (lago_laguna_a.the_geom)::public.geometry(MultiPolygon,32617) AS the_geom
   FROM ((ho_aguas_interiores.lago_laguna_a
     JOIN catalogo_objetos.catalogo_objetos ON (((lago_laguna_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.hyp ON ((lago_laguna_a.hyp = hyp.hyp)));


ALTER TABLE visualizacion.lago_laguna_a OWNER TO postgres;

--
-- TOC entry 432 (class 1259 OID 2453019)
-- Name: muro_l; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.muro_l AS
 SELECT muro_l.gid,
    muro_l.fcode,
    catalogo_objetos.descripcion,
    wti.wti_desc,
    muro_l.txt,
    (muro_l.the_geom)::public.geometry(LineString,32617) AS the_geom
   FROM ((gs_asociado_poblados.muro_l
     JOIN catalogo_objetos.catalogo_objetos ON (((muro_l.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.wti ON ((muro_l.wti = wti.wti)));


ALTER TABLE visualizacion.muro_l OWNER TO postgres;

--
-- TOC entry 433 (class 1259 OID 2453024)
-- Name: orilla_l; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.orilla_l AS
 SELECT orilla_l.gid,
    orilla_l.fcode,
    catalogo_objetos.descripcion,
    acc.acc_desc,
    slt.slt_desc,
    orilla_l.txt,
    (orilla_l.the_geom)::public.geometry(LineString,32617) AS the_geom
   FROM (((ho_zonas_costeras.orilla_l
     JOIN catalogo_objetos.catalogo_objetos ON (((orilla_l.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.acc ON ((orilla_l.acc = acc.acc)))
     JOIN catalogo_objetos.slt ON ((orilla_l.slt = slt.slt)));


ALTER TABLE visualizacion.orilla_l OWNER TO postgres;

--
-- TOC entry 434 (class 1259 OID 2453029)
-- Name: parque_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.parque_a AS
 SELECT parque_a.gid,
    parque_a.fcode,
    catalogo_objetos.descripcion,
    parque_a.nam,
    fuc.fuc_desc,
    parque_a.txt,
    (parque_a.the_geom)::public.geometry(MultiPolygon,32617) AS the_geom
   FROM ((gs_recreacion.parque_a
     JOIN catalogo_objetos.catalogo_objetos ON (((parque_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.fuc ON ((parque_a.fuc = fuc.fuc)));


ALTER TABLE visualizacion.parque_a OWNER TO postgres;

--
-- TOC entry 435 (class 1259 OID 2453034)
-- Name: parqueadero_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.parqueadero_a AS
 SELECT parqueadero_a.gid,
    parqueadero_a.fcode,
    catalogo_objetos.descripcion,
    parqueadero_a.nam,
    smc.smc_desc,
    parqueadero_a.txt,
    (parqueadero_a.the_geom)::public.geometry(MultiPolygon,32617) AS the_geom
   FROM ((it_asociado_transportacion.parqueadero_a
     JOIN catalogo_objetos.catalogo_objetos ON (((parqueadero_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.smc ON ((parqueadero_a.smc = smc.smc)));


ALTER TABLE visualizacion.parqueadero_a OWNER TO postgres;

--
-- TOC entry 436 (class 1259 OID 2453039)
-- Name: paseo_peatonal_ciclovia_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.paseo_peatonal_ciclovia_a AS
 SELECT paseo_peatonal_ciclovia_a.gid,
    paseo_peatonal_ciclovia_a.fcode,
    catalogo_objetos.descripcion,
    paseo_peatonal_ciclovia_a.nam,
    smc.smc_desc,
    paseo_peatonal_ciclovia_a.txt,
    (paseo_peatonal_ciclovia_a.the_geom)::public.geometry(MultiPolygon,32617) AS the_geom
   FROM ((it_asociado_transportacion.paseo_peatonal_ciclovia_a
     JOIN catalogo_objetos.catalogo_objetos ON (((paseo_peatonal_ciclovia_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.smc ON ((paseo_peatonal_ciclovia_a.smc = smc.smc)));


ALTER TABLE visualizacion.paseo_peatonal_ciclovia_a OWNER TO postgres;

--
-- TOC entry 437 (class 1259 OID 2453044)
-- Name: piscina_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.piscina_a AS
 SELECT piscina_a.gid,
    piscina_a.fcode,
    catalogo_objetos.descripcion,
    piscina_a.nam,
    piscina_a.txt,
    (piscina_a.the_geom)::public.geometry(MultiPolygon,32617) AS the_geom
   FROM (gs_recreacion.piscina_a
     JOIN catalogo_objetos.catalogo_objetos ON (((piscina_a.fcode)::text = (catalogo_objetos.fcode)::text)));


ALTER TABLE visualizacion.piscina_a OWNER TO postgres;

--
-- TOC entry 438 (class 1259 OID 2453048)
-- Name: plaza_publica_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.plaza_publica_a AS
 SELECT plaza_publica_a.gid,
    plaza_publica_a.fcode,
    catalogo_objetos.descripcion,
    plaza_publica_a.nam,
    smc.smc_desc,
    plaza_publica_a.txt,
    (plaza_publica_a.the_geom)::public.geometry(MultiPolygon,32617) AS the_geom
   FROM ((gs_asociado_poblados.plaza_publica_a
     JOIN catalogo_objetos.catalogo_objetos ON (((plaza_publica_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.smc ON ((plaza_publica_a.smc = smc.smc)));


ALTER TABLE visualizacion.plaza_publica_a OWNER TO postgres;

--
-- TOC entry 439 (class 1259 OID 2453053)
-- Name: plaza_toros_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.plaza_toros_a AS
 SELECT plaza_toros_a.gid,
    plaza_toros_a.fcode,
    catalogo_objetos.descripcion,
    plaza_toros_a.nam,
    plaza_toros_a.txt,
    (plaza_toros_a.the_geom)::public.geometry(MultiPolygon,32617) AS the_geom
   FROM (gs_recreacion.plaza_toros_a
     JOIN catalogo_objetos.catalogo_objetos ON (((plaza_toros_a.fcode)::text = (catalogo_objetos.fcode)::text)));


ALTER TABLE visualizacion.plaza_toros_a OWNER TO postgres;

--
-- TOC entry 440 (class 1259 OID 2453057)
-- Name: puente_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.puente_a AS
 SELECT puente_a.gid,
    puente_a.fcode,
    catalogo_objetos.descripcion,
    puente_a.nam,
    puente_a.na2,
    acc.acc_desc,
    bsc.bsc_desc,
    puente_a.ltn,
    typ.typ_desc,
    tuc.tuc_desc,
    puente_a.txt,
    (puente_a.the_geom)::public.geometry(MultiPolygon,32617) AS the_geom
   FROM (((((it_cruces_enlaces.puente_a
     JOIN catalogo_objetos.catalogo_objetos ON (((puente_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.acc ON ((puente_a.acc = acc.acc)))
     JOIN catalogo_objetos.bsc ON ((puente_a.bsc = bsc.bsc)))
     JOIN catalogo_objetos.typ ON ((puente_a.typ = typ.typ)))
     JOIN catalogo_objetos.tuc ON ((puente_a.tuc = tuc.tuc)));


ALTER TABLE visualizacion.puente_a OWNER TO postgres;

--
-- TOC entry 441 (class 1259 OID 2453062)
-- Name: puerto_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.puerto_a AS
 SELECT puerto_a.gid,
    puerto_a.fcode,
    catalogo_objetos.descripcion,
    puerto_a.nam,
    puerto_a.txt,
    (puerto_a.the_geom)::public.geometry(MultiPolygon,32617) AS the_geom
   FROM (ho_puertos_muelles.puerto_a
     JOIN catalogo_objetos.catalogo_objetos ON (((puerto_a.fcode)::text = (catalogo_objetos.fcode)::text)));


ALTER TABLE visualizacion.puerto_a OWNER TO postgres;

--
-- TOC entry 442 (class 1259 OID 2453066)
-- Name: punto_control_p; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.punto_control_p AS
 SELECT punto_control_p.gid,
    punto_control_p.fcode,
    catalogo_objetos.descripcion,
    acc.acc_desc,
    ela.ela_desc,
    punto_control_p.zvh,
    punto_control_p.txt,
    (punto_control_p.the_geom)::public.geometry(Point,32617) AS the_geom
   FROM (((d_linderos_propiedad.punto_control_p
     JOIN catalogo_objetos.catalogo_objetos ON (((punto_control_p.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.acc ON ((punto_control_p.acc = acc.acc)))
     JOIN catalogo_objetos.ela ON ((punto_control_p.ela = ela.ela)));


ALTER TABLE visualizacion.punto_control_p OWNER TO postgres;

--
-- TOC entry 443 (class 1259 OID 2453071)
-- Name: rio_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.rio_a AS
 SELECT rio_a.gid,
    rio_a.fcode,
    catalogo_objetos.descripcion,
    rio_a.nam,
    rio_a.na2,
    acc.acc_desc,
    hyp.hyp_desc,
    rio_a.txt,
    (rio_a.the_geom)::public.geometry(MultiPolygon,32617) AS the_geom
   FROM (((catalogo_objetos.catalogo_objetos
     JOIN ho_aguas_interiores.rio_a ON (((catalogo_objetos.fcode)::text = (rio_a.fcode)::text)))
     JOIN catalogo_objetos.acc ON ((rio_a.acc = acc.acc)))
     JOIN catalogo_objetos.hyp ON ((rio_a.hyp = hyp.hyp)));


ALTER TABLE visualizacion.rio_a OWNER TO postgres;

--
-- TOC entry 444 (class 1259 OID 2453076)
-- Name: rio_l; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.rio_l AS
 SELECT rio_l.gid,
    rio_l.fcode,
    catalogo_objetos.descripcion,
    rio_l.nam,
    rio_l.na2,
    acc.acc_desc,
    hyp.hyp_desc,
    rio_l.txt,
    (rio_l.the_geom)::public.geometry(LineString,32617) AS the_geom
   FROM (((catalogo_objetos.catalogo_objetos
     JOIN ho_aguas_interiores.rio_l ON (((catalogo_objetos.fcode)::text = (rio_l.fcode)::text)))
     JOIN catalogo_objetos.acc ON ((rio_l.acc = acc.acc)))
     JOIN catalogo_objetos.hyp ON ((rio_l.hyp = hyp.hyp)));


ALTER TABLE visualizacion.rio_l OWNER TO postgres;

--
-- TOC entry 445 (class 1259 OID 2453081)
-- Name: rodera_l; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.rodera_l AS
 SELECT rodera_l.gid,
    rodera_l.fcode,
    catalogo_objetos.descripcion,
    typ.typ_desc,
    rst.rst_desc,
    hct.hct_desc,
    rdt.rdt_desc,
    wtc.wtc_desc,
    rodera_l.ltn,
    tuc.tuc_desc,
    rodera_l.txt,
    (rodera_l.the_geom)::public.geometry(LineString,32617) AS the_geom
   FROM (((((((it_transporte_terrestre.rodera_l
     JOIN catalogo_objetos.catalogo_objetos ON (((rodera_l.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.typ ON ((rodera_l.typ = typ.typ)))
     JOIN catalogo_objetos.hct ON ((rodera_l.hct = hct.hct)))
     JOIN catalogo_objetos.rst ON ((rodera_l.rst = rst.rst)))
     JOIN catalogo_objetos.rdt ON ((rodera_l.rdt = rdt.rdt)))
     JOIN catalogo_objetos.wtc ON ((rodera_l.wtc = wtc.wtc)))
     JOIN catalogo_objetos.tuc ON ((rodera_l.tuc = tuc.tuc)));


ALTER TABLE visualizacion.rodera_l OWNER TO postgres;

--
-- TOC entry 446 (class 1259 OID 2453086)
-- Name: sendero_l; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.sendero_l AS
 SELECT sendero_l.gid,
    sendero_l.fcode,
    catalogo_objetos.descripcion,
    wtc.wtc_desc,
    sendero_l.txt,
    (sendero_l.the_geom)::public.geometry(LineString,32617) AS the_geom
   FROM ((it_transporte_terrestre.sendero_l
     JOIN catalogo_objetos.catalogo_objetos ON (((sendero_l.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.wtc ON ((sendero_l.wtc = wtc.wtc)));


ALTER TABLE visualizacion.sendero_l OWNER TO postgres;

--
-- TOC entry 447 (class 1259 OID 2453091)
-- Name: tunel_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.tunel_a AS
 SELECT tunel_a.gid,
    tunel_a.fcode,
    catalogo_objetos.descripcion,
    tunel_a.nam,
    tra.tra_desc,
    tuc.tuc_desc,
    tunel_a.txt,
    tunel_a.the_geom
   FROM (((it_asociado_transportacion.tunel_a
     JOIN catalogo_objetos.catalogo_objetos ON (((tunel_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.tra ON ((tunel_a.tra = tra.tra)))
     JOIN catalogo_objetos.tuc ON ((tunel_a.tuc = tuc.tuc)));


ALTER TABLE visualizacion.tunel_a OWNER TO postgres;

--
-- TOC entry 448 (class 1259 OID 2453096)
-- Name: via_ruta_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.via_ruta_a AS
 SELECT via_ruta_a.gid,
    via_ruta_a.fcode,
    catalogo_objetos.descripcion,
    via_ruta_a.nam,
    via_ruta_a.na2,
    acc.acc_desc,
    rst.rst_desc,
    typ.typ_desc,
    hct.hct_desc,
    loc.loc_desc,
    via_ruta_a.ltn,
    mes.mes_desc,
    rdt.rdt_desc,
    tuc.tuc_desc,
    via_ruta_a.txt,
    (via_ruta_a.the_geom)::public.geometry(MultiPolygon,32617) AS the_geom
   FROM (((((((((it_transporte_terrestre.via_ruta_a
     JOIN catalogo_objetos.catalogo_objetos ON (((via_ruta_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.acc ON ((via_ruta_a.acc = acc.acc)))
     JOIN catalogo_objetos.rst ON ((via_ruta_a.rst = rst.rst)))
     JOIN catalogo_objetos.typ ON ((via_ruta_a.typ = typ.typ)))
     JOIN catalogo_objetos.hct ON ((via_ruta_a.hct = hct.hct)))
     JOIN catalogo_objetos.loc ON ((via_ruta_a.loc = loc.loc)))
     JOIN catalogo_objetos.mes ON ((via_ruta_a.mes = mes.mes)))
     JOIN catalogo_objetos.rdt ON ((via_ruta_a.rdt = rdt.rdt)))
     JOIN catalogo_objetos.tuc ON ((via_ruta_a.tuc = tuc.tuc)));


ALTER TABLE visualizacion.via_ruta_a OWNER TO postgres;

--
-- TOC entry 449 (class 1259 OID 2453101)
-- Name: zanja_l; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.zanja_l AS
 SELECT zanja_l.gid,
    zanja_l.fcode,
    catalogo_objetos.descripcion,
    hyp.hyp_desc,
    zanja_l.txt,
    (zanja_l.the_geom)::public.geometry(LineString,32617) AS the_geom
   FROM ((ho_aguas_interiores.zanja_l
     JOIN catalogo_objetos.catalogo_objetos ON (((zanja_l.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.hyp ON ((zanja_l.hyp = hyp.hyp)));


ALTER TABLE visualizacion.zanja_l OWNER TO postgres;

--
-- TOC entry 6464 (class 2604 OID 2453106)
-- Name: aeropuerto_a gid; Type: DEFAULT; Schema: a_aeropuerto_superficie; Owner: postgres
--

ALTER TABLE ONLY a_aeropuerto_superficie.aeropuerto_a ALTER COLUMN gid SET DEFAULT nextval('a_aeropuerto_superficie.aeropuerto_a_gid_seq'::regclass);


--
-- TOC entry 6470 (class 2604 OID 2453107)
-- Name: catalogo_objetos gid; Type: DEFAULT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.catalogo_objetos ALTER COLUMN gid SET DEFAULT nextval('catalogo_objetos.catalogo_objetos_gid_seq'::regclass);


--
-- TOC entry 6472 (class 2604 OID 2453108)
-- Name: punto_control_p gid; Type: DEFAULT; Schema: d_linderos_propiedad; Owner: postgres
--

ALTER TABLE ONLY d_linderos_propiedad.punto_control_p ALTER COLUMN gid SET DEFAULT nextval('d_linderos_propiedad.vertice_geodesico_p_gid_seq'::regclass);


--
-- TOC entry 6479 (class 2604 OID 2453109)
-- Name: cementerio_a gid; Type: DEFAULT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.cementerio_a ALTER COLUMN gid SET DEFAULT nextval('gs_asociado_poblados.cementerio_a_gid_seq'::regclass);


--
-- TOC entry 6486 (class 2604 OID 2453110)
-- Name: cerca_l gid; Type: DEFAULT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.cerca_l ALTER COLUMN gid SET DEFAULT nextval('gs_asociado_poblados.cerca_l_gid_seq'::regclass);


--
-- TOC entry 6493 (class 2604 OID 2453111)
-- Name: escalinata_a gid; Type: DEFAULT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.escalinata_a ALTER COLUMN gid SET DEFAULT nextval('gs_asociado_poblados.escalinata_a_gid_seq'::regclass);


--
-- TOC entry 6500 (class 2604 OID 2453112)
-- Name: muro_l gid; Type: DEFAULT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.muro_l ALTER COLUMN gid SET DEFAULT nextval('gs_asociado_poblados.muro_l_gid_seq'::regclass);


--
-- TOC entry 6507 (class 2604 OID 2453113)
-- Name: plaza_publica_a gid; Type: DEFAULT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.plaza_publica_a ALTER COLUMN gid SET DEFAULT nextval('gs_asociado_poblados.plaza_publica_a_gid_seq'::regclass);


--
-- TOC entry 6514 (class 2604 OID 2453114)
-- Name: edificio_a gid; Type: DEFAULT; Schema: gs_construcciones; Owner: postgres
--

ALTER TABLE ONLY gs_construcciones.edificio_a ALTER COLUMN gid SET DEFAULT nextval('gs_construcciones.edificio_a_gid_seq'::regclass);


--
-- TOC entry 6521 (class 2604 OID 2453115)
-- Name: cancha_a gid; Type: DEFAULT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.cancha_a ALTER COLUMN gid SET DEFAULT nextval('gs_recreacion.cancha_a_gid_seq'::regclass);


--
-- TOC entry 6528 (class 2604 OID 2453116)
-- Name: estadio_a gid; Type: DEFAULT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.estadio_a ALTER COLUMN gid SET DEFAULT nextval('gs_recreacion.estadio_a_gid_seq'::regclass);


--
-- TOC entry 6535 (class 2604 OID 2453117)
-- Name: parque_a gid; Type: DEFAULT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.parque_a ALTER COLUMN gid SET DEFAULT nextval('gs_recreacion.parque_a_gid_seq'::regclass);


--
-- TOC entry 6542 (class 2604 OID 2453118)
-- Name: piscina_a gid; Type: DEFAULT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.piscina_a ALTER COLUMN gid SET DEFAULT nextval('gs_recreacion.piscina_a_gid_seq'::regclass);


--
-- TOC entry 6549 (class 2604 OID 2453119)
-- Name: plaza_toros_a gid; Type: DEFAULT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.plaza_toros_a ALTER COLUMN gid SET DEFAULT nextval('gs_recreacion.plaza_toros_a_gid_seq'::regclass);


--
-- TOC entry 6556 (class 2604 OID 2453120)
-- Name: acequia_l gid; Type: DEFAULT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.acequia_l ALTER COLUMN gid SET DEFAULT nextval('ho_aguas_interiores.acequia_l_gid_seq'::regclass);


--
-- TOC entry 6563 (class 2604 OID 2453121)
-- Name: acueducto_canal_a gid; Type: DEFAULT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.acueducto_canal_a ALTER COLUMN gid SET DEFAULT nextval('ho_aguas_interiores.acueducto_canal_a_gid_seq'::regclass);


--
-- TOC entry 6570 (class 2604 OID 2453122)
-- Name: lago_laguna_a gid; Type: DEFAULT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.lago_laguna_a ALTER COLUMN gid SET DEFAULT nextval('ho_aguas_interiores.lago_laguna_a_gid_seq'::regclass);


--
-- TOC entry 6577 (class 2604 OID 2453123)
-- Name: rio_a gid; Type: DEFAULT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.rio_a ALTER COLUMN gid SET DEFAULT nextval('ho_aguas_interiores.rio_a_gid_seq'::regclass);


--
-- TOC entry 6584 (class 2604 OID 2453124)
-- Name: rio_l gid; Type: DEFAULT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.rio_l ALTER COLUMN gid SET DEFAULT nextval('ho_aguas_interiores.rio_l_gid_seq'::regclass);


--
-- TOC entry 6591 (class 2604 OID 2453125)
-- Name: zanja_l gid; Type: DEFAULT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.zanja_l ALTER COLUMN gid SET DEFAULT nextval('ho_aguas_interiores.zanja_l_gid_seq'::regclass);


--
-- TOC entry 6598 (class 2604 OID 2453126)
-- Name: puerto_a gid; Type: DEFAULT; Schema: ho_puertos_muelles; Owner: postgres
--

ALTER TABLE ONLY ho_puertos_muelles.puerto_a ALTER COLUMN gid SET DEFAULT nextval('ho_puertos_muelles.puerto_a_gid_seq'::regclass);


--
-- TOC entry 6605 (class 2604 OID 2453127)
-- Name: granja_acuatica_a gid; Type: DEFAULT; Schema: ho_regulacion_zonas_restringidas; Owner: postgres
--

ALTER TABLE ONLY ho_regulacion_zonas_restringidas.granja_acuatica_a ALTER COLUMN gid SET DEFAULT nextval('ho_regulacion_zonas_restringidas.granja_acuatica_a_gid_seq'::regclass);


--
-- TOC entry 6612 (class 2604 OID 2453128)
-- Name: isla_a gid; Type: DEFAULT; Schema: ho_zonas_costeras; Owner: postgres
--

ALTER TABLE ONLY ho_zonas_costeras.isla_a ALTER COLUMN gid SET DEFAULT nextval('ho_zonas_costeras.isla_a_gid_seq'::regclass);


--
-- TOC entry 6619 (class 2604 OID 2453129)
-- Name: orilla_l gid; Type: DEFAULT; Schema: ho_zonas_costeras; Owner: postgres
--

ALTER TABLE ONLY ho_zonas_costeras.orilla_l ALTER COLUMN gid SET DEFAULT nextval('ho_zonas_costeras.orilla_l_gid_seq'::regclass);


--
-- TOC entry 6633 (class 2604 OID 2453130)
-- Name: acera_a gid; Type: DEFAULT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.acera_a ALTER COLUMN gid SET DEFAULT nextval('it_asociado_transportacion.acera_a_gid_seq'::regclass);


--
-- TOC entry 6640 (class 2604 OID 2453131)
-- Name: bordillo_l gid; Type: DEFAULT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.bordillo_l ALTER COLUMN gid SET DEFAULT nextval('it_asociado_transportacion.bordillo_l_gid_seq'::regclass);


--
-- TOC entry 6647 (class 2604 OID 2453132)
-- Name: cuneta_a gid; Type: DEFAULT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.cuneta_a ALTER COLUMN gid SET DEFAULT nextval('it_asociado_transportacion.cuneta_a_gid_seq'::regclass);


--
-- TOC entry 6654 (class 2604 OID 2453133)
-- Name: parqueadero_a gid; Type: DEFAULT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.parqueadero_a ALTER COLUMN gid SET DEFAULT nextval('it_asociado_transportacion.parqueadero_a_gid_seq'::regclass);


--
-- TOC entry 6661 (class 2604 OID 2453134)
-- Name: paseo_peatonal_ciclovia_a gid; Type: DEFAULT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.paseo_peatonal_ciclovia_a ALTER COLUMN gid SET DEFAULT nextval('it_asociado_transportacion.paseo_peatonal_ciclovia_a_gid_seq'::regclass);


--
-- TOC entry 6668 (class 2604 OID 2453135)
-- Name: tunel_a gid; Type: DEFAULT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.tunel_a ALTER COLUMN gid SET DEFAULT nextval('it_asociado_transportacion.tunel_a_gid_seq'::regclass);


--
-- TOC entry 6675 (class 2604 OID 2453136)
-- Name: puente_a gid; Type: DEFAULT; Schema: it_cruces_enlaces; Owner: postgres
--

ALTER TABLE ONLY it_cruces_enlaces.puente_a ALTER COLUMN gid SET DEFAULT nextval('it_cruces_enlaces.puente_a_gid_seq'::regclass);


--
-- TOC entry 6682 (class 2604 OID 2453137)
-- Name: ferrocarril_a gid; Type: DEFAULT; Schema: it_ferrocarriles; Owner: postgres
--

ALTER TABLE ONLY it_ferrocarriles.ferrocarril_a ALTER COLUMN gid SET DEFAULT nextval('it_ferrocarriles.ferrocarril_a_gid_seq'::regclass);


--
-- TOC entry 6689 (class 2604 OID 2453138)
-- Name: gasolinera_a gid; Type: DEFAULT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.gasolinera_a ALTER COLUMN gid SET DEFAULT nextval('it_transporte_terrestre.gasolinera_a_gid_seq'::regclass);


--
-- TOC entry 6696 (class 2604 OID 2453139)
-- Name: intercambiador_vial_a gid; Type: DEFAULT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.intercambiador_vial_a ALTER COLUMN gid SET DEFAULT nextval('it_transporte_terrestre.intercambiador_vial_a_gid_seq'::regclass);


--
-- TOC entry 6703 (class 2604 OID 2453140)
-- Name: rodera_l gid; Type: DEFAULT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.rodera_l ALTER COLUMN gid SET DEFAULT nextval('it_transporte_terrestre.rodera_l_gid_seq'::regclass);


--
-- TOC entry 6710 (class 2604 OID 2453141)
-- Name: sendero_l gid; Type: DEFAULT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.sendero_l ALTER COLUMN gid SET DEFAULT nextval('it_transporte_terrestre.sendero_l_gid_seq'::regclass);


--
-- TOC entry 6717 (class 2604 OID 2453142)
-- Name: via_ruta_a gid; Type: DEFAULT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.via_ruta_a ALTER COLUMN gid SET DEFAULT nextval('it_transporte_terrestre.via_ruta_a_gid_seq'::regclass);


--
-- TOC entry 7334 (class 0 OID 2452394)
-- Dependencies: 309
-- Data for Name: aeropuerto_a; Type: TABLE DATA; Schema: a_aeropuerto_superficie; Owner: postgres
--



--
-- TOC entry 7336 (class 0 OID 2452406)
-- Dependencies: 311
-- Data for Name: acc; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.acc VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.acc VALUES (1, '1.- Exacta');
INSERT INTO catalogo_objetos.acc VALUES (2, '2.- Aproximada');
INSERT INTO catalogo_objetos.acc VALUES (3, '3.- Dudosa');
INSERT INTO catalogo_objetos.acc VALUES (7, '7.- Precisa');
INSERT INTO catalogo_objetos.acc VALUES (998, '998.- No aplica');


--
-- TOC entry 7337 (class 0 OID 2452409)
-- Dependencies: 312
-- Data for Name: atc; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.atc VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.atc VALUES (1, '1.- Pozo Qanat');
INSERT INTO catalogo_objetos.atc VALUES (3, '3.- Acueducto subterráneo');
INSERT INTO catalogo_objetos.atc VALUES (4, '4.- Bajo el agua');
INSERT INTO catalogo_objetos.atc VALUES (5, '5.- Superficie');
INSERT INTO catalogo_objetos.atc VALUES (998, '998.- No aplica');


--
-- TOC entry 7338 (class 0 OID 2452412)
-- Dependencies: 313
-- Data for Name: bsc; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.bsc VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.bsc VALUES (1, '1.- Arco abierto Spandrel');
INSERT INTO catalogo_objetos.bsc VALUES (2, '2.- Voladizo');
INSERT INTO catalogo_objetos.bsc VALUES (3, '3.- Cubierta');
INSERT INTO catalogo_objetos.bsc VALUES (5, '5.- Flotante');
INSERT INTO catalogo_objetos.bsc VALUES (6, '6.- De viga');
INSERT INTO catalogo_objetos.bsc VALUES (7, '7.- Torre de suspensión');
INSERT INTO catalogo_objetos.bsc VALUES (8, '8.- Entramado');
INSERT INTO catalogo_objetos.bsc VALUES (9, '9.- Suspensión');
INSERT INTO catalogo_objetos.bsc VALUES (12, '12.- Transportador');
INSERT INTO catalogo_objetos.bsc VALUES (15, '15.- De losa');
INSERT INTO catalogo_objetos.bsc VALUES (16, '16.- Viga y largero');
INSERT INTO catalogo_objetos.bsc VALUES (19, '19.- Cuerda del arco del puente');
INSERT INTO catalogo_objetos.bsc VALUES (22, '22.- Cubierto');
INSERT INTO catalogo_objetos.bsc VALUES (26, '26.- Arco cerrado spandrel');
INSERT INTO catalogo_objetos.bsc VALUES (27, '27.- Atirantado');
INSERT INTO catalogo_objetos.bsc VALUES (28, '28.- Viaducto');
INSERT INTO catalogo_objetos.bsc VALUES (31, '31.- Arco');
INSERT INTO catalogo_objetos.bsc VALUES (32, '32.- Caballete');
INSERT INTO catalogo_objetos.bsc VALUES (998, '998.- No aplica');


--
-- TOC entry 7339 (class 0 OID 2452415)
-- Dependencies: 314
-- Data for Name: catalogo_objetos; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AA051', 'Boca de Pozo', 'Equipo utilizado para mantener el control de un pozo, incluyen accesorios como válvulas.', 1);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AA052', 'Campo de Petróleo/Gas', 'Área donde se ha identificado la presencia de petróleo, aceite y/o gas natural.', 2);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AA012', 'Cantera', 'Explotación generalmente a cielo abierto de la que se obtienen rocas industriales, ornamentales y otros materiales usados en la construcción.', 3);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AA010', 'Mina', 'Excavación hecha en la tierra para la extracción de materiales de depósitos naturales.', 4);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AA050', 'Pozo', 'Excavación o perforación hecha en la tierra o mar para la extracción de líquidos o gases.', 5);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AA040', 'Torre de Perforación', 'Superestructura equipada para la perforación o el levantamiento de las operaciones de extracción y / o explotación de recursos naturales.', 6);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BB241', 'Astillero', 'Área  al lado del mar o un río importante, que incluye  instalaciones en las que los buques se construyen o reparan.', 7);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AC040', 'Instalación Petrolera', 'Área con instalaciones para la producción o distribución de petróleo, aceite y/o productos de gas natural.', 8);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AC000', 'Planta de Procesamiento', 'Instalación que incluye uno o más edificios utilizados para procesar materiales.', 9);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH220', 'Planta de Tratamiento de Agua', 'Instalaciones para el almacenamiento, purificación y suministro del agua para un área o una ciudad.', 10);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AE010', 'Planta Ensambladora', 'Edificio o grupo de edificios dedicados a combinar piezas fabricadas para obtener un producto terminado.', 11);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AC030', 'Tanque de Decantación', 'Sitio donde la materia sólida se precipita de un líquido mediante sedimentación.', 12);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH175', 'Abrevadero', 'Contenedor abierto de retención de agua para dar de beber a los animales.', 13);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AJ030', 'Corral', 'Lugar cerrado en el cual el ganado es custodiado temporalmente.', 14);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AJ080', 'Establo', 'Lugar cubierto adaptado para el refugio y alimentación del ganado y las aves.', 15);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AJ060', 'Hacienda', 'Lugar que puede ser de cualquier tamaño desde unas pocas hectáreas a miles de hectáreas, y puede estar especializada en una particular forma de producción de alimento y/o ganado.', 16);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AJ070', 'Rancho', 'Extensión de tierra, incluye las estructuras, cuyo principal uso es el pastoreo de ganado en general, puede presentar también cultivos.', 17);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH240', 'Sistema de Irrigación', 'Sistema para proveer de agua a la tierra, generalmente a través de una red de canales o tuberías.', 18);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AD010', 'Central Eléctrica', 'Edificio y equipamiento necesario para la generación de energía eléctrica.', 19);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AT030', 'Línea de Transmisión Eléctrica', 'Cable que transmite o distribuye energía eléctrica.', 20);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AD030', 'Subestación Eléctrica', 'Infraestructura localizada sobre la ruta de la línea de energía eléctrica en la cual se transforma  y/o se distribuye la energía.', 21);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AT010', 'Antena Parabólica', 'Objeto cóncavo utilizado para la transmisión o recepción de señales electromagnéticas.', 22);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AT060', 'Línea Telefónica', 'Sistema de comunicación que transmite señales eléctricas con información a distancias muy largas.', 23);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AT080', 'Torre de Comunicación', 'Estructura relativamente alta utilizada para transmitir, y/o recibir señales de comunicación electromagnéticas.', 24);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AF010', 'Chimenea', 'Estructura vertical que contiene un tubo o cañón para descarga de humo o gases de combustión.', 25);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AF070', 'Mechero', 'Tubería abierta en la cual los gases residuales son quemados.', 26);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AF030', 'Torre de Enfriamiento', 'Torre utilizada para enfriar líquidos.', 27);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AQ113', 'Tubería', 'Serie de tubos conectados para el transporte de sólidos, líquidos o gases.', 28);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AM010', 'Bodega', 'Área utilizada para almacenamiento de productos o suministros.', 29);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AM040', 'Pila Mineral', 'Montículo de productos mineros o de cantera, extraídos por el hombre, que no contienen materiales de desecho.', 30);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AM091', 'Silo', 'Contenedor cilíndrico cerrado, utilizado para guardar el grano o forraje.', 31);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AM070', 'Tanque de Almacenamiento', 'Depósito usado para el almacenamiento de líquidos y/o gases.', 32);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AM080', 'Torre de Agua', 'Torre que sirve de apoyo a un tanque elevado de almacenamiento de agua.', 33);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AB021', 'Difusor/Colector', 'Instalación artificial, generalmente subterránea donde los líquidos son evacuados.', 34);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AB030', 'Instalación para Procesamiento de Residuos', 'Sitio funcional con edificios y otras instalaciones, donde los residuos son procesados a través de  procedimientos químicos, físicos, biológicos o térmicos, o combinaciones de estos.', 35);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AB000', 'Vertedero/Basurero', 'Área para la recolección o depósito de materiales de desecho o descarga.', 36);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AL135', 'Comunidad', 'Concentración de viviendas nativas, generalmente chozas, usualmente de construcción tradicional.', 37);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AL015', 'Edificio', 'Estructura techada relativamente permanente, diseñada para algún uso particular.', 38);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AL105', 'Poblado', 'Concentración continua ocupada de tiendas  o ligeras estructuras fijas (por ejemplo: chozas) que sirven como residencia.', 39);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AL020', 'Zona Edificada', 'Área que contiene concentración de construcciones y/u otras estructuras.', 40);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AL030', 'Cementerio', 'Sitio de estructuras asociadas, utilizadas para el entierro de muertos.', 41);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AL070', 'Cerca', 'Barrera artificial construida por el hombre de estructura relativamente liviana utilizada como cercado o límite.', 42);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AL099', 'Choza', 'Construcción rústica, pequeña, sencilla e independiente que por lo general tiene una sola habitación individual multifunción.', 43);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AQ150', 'Escalinata', 'Serie de escalones que sirven para subir a un plano más elevado o para bajar a un plano inferior.', 44);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AL130', 'Monumento', 'Estructura levantada o mantenida en memoria a una persona o evento.', 45);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AL260', 'Muro', 'Barrera hecha por el hombre de material resistente utilizado como límite o para protección.', 46);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AL170', 'Plaza Pública', 'Sitio abierto y que sirve como lugar de reunión pública en una zona poblada para diversos usos.', 47);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH230', 'Pozo de Agua', 'Excavación o perforación hecha en la tierra para la extracción de agua.', 48);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AL241', 'Torre', 'Estructura relativamente alta,  que puede presentarse sola o puede formar parte de otra estructura.', 49);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AL240', 'Torre que no es para Comunicación', 'Torre  que se utiliza para fines distintos de la comunicación.', 50);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AG030', 'Complejo Comercial', 'Instalaciones comerciales de varios  almacenes, con restaurantes, lugares de entretenimiento y  otras empresas,  está completamente cubierto y cuenta con una amplia zona de estacionamiento.', 51);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BA011', 'Línea de Costa', 'Línea generada por el contacto entre la tierra y un cuerpo de agua afectado por mareas y definida por el nivel de la pleamar media.', 98);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AL014', 'Estructura no Construida', 'Construcción económicamente independiente,  diseñada para apoyar las actividades humanas (por ejemplo:  agricultura,  industria o minería), pero no destinados a la ocupación humana y/o habitación.', 52);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AL011', 'Instalación', 'Agrupación de instalaciones, situadas en la misma zona, que apoyan funciones particulares.', 53);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AK200', 'Balneario', 'Establecimiento que se levanta cerca de fuentes de aguas mineromedicinales (declaradas de utilidad pública) con la finalidad de utilizar sus propiedades terapéuticas y estéticas.', 54);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AK040', 'Cancha', 'Lugar al aire libre destinado a eventos deportivos, ejercicio o juegos.', 55);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AK160', 'Coliseo', 'Escenario parcial o totalmente rodeado por una estructura diseñada para permitir a los espectadores de pie o sentados visualizar un evento.  A menudo diseñados en forma y tamaño para dar cabida a deportes específicos (por ejemplo: fútbol, ​​baloncesto, etc.), teatro o actuaciones musicales.', 56);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AK165', 'Estadio', 'Campo deportivo parcial o totalmente rodeado por una estructura diseñada para permitir a los espectadores ver un evento de pie o sentados; a menudo diseñados en forma y tamaño para dar cabida a deportes específicos (por ejemplo: el fútbol).', 57);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AK121', 'Mirador', 'Área, generalmente en un lugar elevado, con infraestructura para observaciones del paisaje circundante.', 58);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AK120', 'Parque', 'Área utilizada con propósitos recreacionales u ornamentales.', 59);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AK030', 'Parque de Diversión', 'Instalación predominantemente artificial, equipada con dispositivos recreacionales.', 60);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AK190', 'Paseo Marítimo', 'Estructura que se extiende en el agua utilizada con propósitos recreacionales, no pretende ser un lugar de atraque de buques.', 61);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AK170', 'Piscina', 'Construcción destinada a contener agua con fines de recreación y natación.', 62);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AK130', 'Pista de Carreras', 'Superficie que se utiliza para competencias de carreras.', 63);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AK166', 'Plaza de Toros', 'Construcción generalmente circular u ovalada, de cielo abierto, rodeada por graderíos para los espectadores.', 64);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AK090', 'Recinto Ferial', 'Área donde existen instalaciones permanentes al aire libre para realizar ferias, circos o exhibiciones.', 65);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AL200', 'Ruinas', 'Remanentes deteriorados de estructuras no especificadas.', 66);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AL012', 'Sitio Arqueológico', 'Sitio donde se ha descubierto la existencia de restos de civilizaciones ancestrales o actividades humanas.', 67);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AL201', 'Sitio Histórico', 'Sitio o área declarada de significado histórico nacional o provincial mantenido para el público.', 68);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AK110', 'Tribuna', 'Estructura elevada en vías, centros deportivos, etc. generalmente para la presentación especial de eventos al aire libre.', 69);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AK180', 'Zoológico', 'Lugar donde los animales, generalmente salvajes, se mantienen en exposición al público, pueden reproducirse y ser estudiados.', 70);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AL142', 'Observatorio Astronómico', 'Edificio diseñado y equipado para realizar observaciones de objetos celestes, del espacio y del universo en su conjunto.', 71);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AN010', 'Ferrocarril', 'Una o más vías de ferrocarril que comprende una red utilizada para el transporte de pasajeros y/o bienes.', 72);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AN070', 'Estación de Ferrocarril', 'Instalación en la que los pasajeros pueden subir y bajar de los trenes y/o cargar  y descargar  mercancías del transporte ferroviario.', 73);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AQ180', 'Estación de Pesaje', 'Construcción y equipos asociados que se utilizan para examinar y pesar  los vehículos de motor.', 74);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AQ170', 'Gasolinera', 'Establecimiento en el cual se vende combustible y lubricantes generalmente para vehículos de motor.', 75);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AP020', 'Intercambiador Vial', 'Conexión diseñada para facilitar el acceso del tráfico de una carretera a  otra.', 76);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AP010', 'Rodera', 'Vía natural con poca o ninguna mejora por la que pueden transitar vehículos de doble tracción.', 77);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AP050', 'Sendero', 'Camino angosto abierto por el tránsito de personas o animales.', 78);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AP030', 'Vía o Ruta', 'Trayecto con una superficie especialmente  preparada que se mantiene para ser usada por vehículos generalmente a motor.', 79);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AT041', 'Transporte Aéreo por Cable', 'Sistema de transporte que consiste en cables de carga  unidos entre torres en los que están suspendidas las unidades (por ejemplo: tarabita, teleférico).', 80);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AQ070', 'Gabarra', 'Ruta definida que cruza una gabarra de una orilla a otra.', 81);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AQ040', 'Puente', 'Estructura que conecta dos lugares y facilita el paso  de una ruta de  transporte (por ejemplo:carretera o ferrocarril)  sobre un obstáculo del terreno (por ejemplo: cuerpo de agua, barranco y/o carretera).', 82);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AQ065', 'Alcantarilla', 'Estructura hecha por el hombre que permite el cruce de un cauce de agua bajo una vía u otra infraestructura, así como una construcción destinada a evacuar aguas residuales.', 83);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AP040', 'Control Vehicular', 'Barrera en una ruta de transporte (por ejemplo: una carretera, un ferrocarril, un túnel o un puente) que controla el paso (puede ser abierto o cerrado).', 84);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AQ036', 'Cuneta', 'Borde de hormigón, asfalto o piedras que forman parte de un canal a lo largo del borde de una calle o carretera.', 85);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AQ080', 'Estación de Gabarra', 'Lugar donde una gabarra toma o descarga su carga.', 86);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AM510', 'Estación de Transbordo', 'Complejo de edificios, instalaciones asociadas, carreteras y zonas adaptadas, utilizadas para el transbordo de pasajeros y carga entre los mismos o diferentes tipos de transporte.', 87);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AQ125', 'Estación de Transporte', 'Estación que sirve como un punto de parada a lo largo de una ruta de transporte.', 88);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AQ140', 'Parqueadero', 'Lugar destinado generalmente para estacionar vehículos.', 89);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AP034', 'Parterre', 'Obra o espacio vial entre dos rutas de transporte para separar el flujo del tráfico (por ejemplo, en sentido contrario).', 90);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AP031', 'Paseo Peatonal / Ciclovía', 'Franja de terreno pavimentada o mejorada que tiene por objeto servir como una vía para  peatones, animales y/o vehículos no motorizado.', 91);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AQ152', 'Puente Peatonal', 'Estructura elevada o suspendida que permite el  paso de peatones.', 92);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AQ060', 'Torre de Control', 'Estructura que alberga personas y equipos que cumplen con  la función de controlar el tráfico aéreo, náutico o de trenes.', 93);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AQ130', 'Túnel', 'Paso subterráneo o submarino, abierto para establecer comunicación.', 94);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH190', 'Albufera', 'Laguna natural que se forma en una bahía o entrada de mar cuya boca ha quedado cerrada por cordones de arena o arrecifes de coral.', 95);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BA023', 'Anteplaya', 'La parte de la costa o playa que se encuentra entre la línea de bajamar y el límite superior de la acción del oleaje normal (arena, grava, arcilla y barro).', 96);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BA030', 'Isla', 'Masa de tierra más pequeña que un continente y rodeada por agua.', 97);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BA040', 'Mar', 'Masa de agua salada que cubre la mayor parte de la superficie de la Tierra.', 99);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BA010', 'Orilla', 'Línea donde una superficie está en contacto con un cuerpo de agua.', 100);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BA050', 'Playa', 'Ribera del mar o de un río grande, formada de arenales en un superficie casi plana.', 101);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BA051', 'Dique', 'Barrera o construcción para contener o detener el agua.', 102);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BI030', 'Esclusa', 'Un par o una serie de compuertas utilizadas para levantar y bajar los barcos a medida que pasan desde el nivel del agua a otra.', 103);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BB043', 'Malecón', 'Murallón que corre paralelo a la orilla del mar o de un río, con la finalidad de proteger de las aguas.', 104);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BB190', 'Muelle', 'Obra construida en un puerto de mar o en la orilla de un río navegable para facilitar las tareas de carga, descarga y para atracar los barcos.', 105);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BB005', 'Puerto', 'Conjunto de obras, instalaciones y servicios que proporcionan el espacio necesario para la estancia de los buques mientras realizan operaciones de carga, descarga, almacenaje y tránsito de viajeros.', 106);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BB041', 'Rompeolas', 'Estructura avanzada hacia el mar que protege un puerto o playa de la acción de las olas.', 107);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BE015', 'Curva Batimétrica', 'Línea que conecta puntos de igual profundidad y por debajo del datum hidrográfico.', 108);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BC020', 'Boya', 'Objeto flotante que se sujeta al fondo del mar, de un lago o de un río, que sirve como ayuda a la navegación.', 109);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BC050', 'Faro', 'Estructura distintiva dentro o fuera de la costa con luz en su parte superior, diseñado para servir como una ayuda a la navegación.', 110);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BD120', 'Arrecife', 'Costa peñascosa, formada en el mar por roca o coral, casi a flor de agua, que constituye peligro para la navegación.', 111);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BD180', 'Naufragio', 'Ruinas de un barco hundido o irreversiblemente dañado.', 112);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BD110', 'Plataforma marina', 'Superficie plana levantada sobre el mar, como etapa de trabajo en la conducción de operaciones mar adentro.', 113);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BD130', 'Roca', 'Formación rocosa aislada, piedra o coral de gran tamaño, que constituye un peligro para la navegación.', 114);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH050', 'Granja Acuática', 'Área cerrada de agua utilizada para la reproducción o cría de camarones, peces y similares.', 115);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH030', 'Acequia', 'Excavación poco profunda construida en tierra con propósitos de drenaje o irrigación.', 116);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH010', 'Acueducto o Canal', 'Cauce artificial que transporta agua en forma de flujo continuo desde un lugar en el que ésta es accesible para consumo u otros usos.', 117);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH090', 'Área de Inundación', 'Área periódicamente cubierta por agua, excluyendo el agua por marea.', 118);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH011', 'Bocatoma', 'Lugar donde el agua es captada en un canal, tubería u otro cuerpo de agua.', 119);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH020', 'Canal de Navegación', 'Canal artificial sin flujo o flujo controlado, construido o usado para navegación.', 120);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH200', 'Característica Miscelánea de Drenaje de Superficie', 'Característica de drenaje de superficie la cual es de naturaleza menor y que no está incluida en otros elementos codificado en estas especificaciones.', 121);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH180', 'Cascada', 'Caída vertical de un curso de agua, producida por brusco desnivel del cauce.', 122);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH015', 'Ciénaga', 'Área permanentemente húmeda de la tierra formada por materia orgánica en descomposición y sobre todo de agua dulce estancada.', 123);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BI010', 'Cisterna', 'Contenedor cubierto, construido por el hombre utilizado para recolectar y almacenar el agua.', 124);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BI040', 'Compuerta', 'Puerta utilizada para regular el flujo de agua.', 125);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH130', 'Embalse', 'Depósito artificial en el que se almacenan las aguas de un río o un arroyo, generalmente mediante una presa o un dique que cierra la boca de un valle.', 126);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AQ116', 'Estación de Bombeo', 'Instalación para mover sólidos, líquidos o gases a través de presión o succión.', 127);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH081', 'Estanque', 'Depósito construido para recolección o almacenamiento de agua para consumo humano o agropecuario.', 128);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH155', 'Evaporador Salino', 'Piscina poco profunda, normalmente construida por el hombre, en donde se recoge sal por la evaporación natural del agua.', 129);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH080', 'Lago o Laguna', 'Cuerpo de agua, dulce o salada, rodeada por tierra.', 130);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH170', 'Manantial', 'Flujo natural de agua que brota en la superficie de la tierra.', 131);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BI020', 'Presa', 'Estructura generalmente de cemento armado, construida a través de un río, arroyo o canal  para contener o controlar el caudal.', 132);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH145', 'Punto Desvanecido', 'Lugar en el cual la corriente de agua desaparece o se desvanece en el terreno.', 133);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH120', 'Rápidos', 'Partes de un río, donde la corriente fluye con gran rapidez, debido a alteraciones en la superficie provocadas por obstrucciones tale como rocas y peñascos.', 134);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH140', 'Río', 'Curso de agua que fluye naturalmente.', 135);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AJ020', 'Sifón', 'Tubería utilizada para el transporte de líquidos de un nivel  a un nivel inferior, usando la diferencia de presión del líquido para forzar subir a la columna hasta un nivel más alto antes de que caiga a la salida.', 136);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH070', 'Vado', 'Sitio poco profundo en un río o corriente de agua utilizado para cruzar a pie, a caballo o en vehículo.', 137);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH100', 'Zanja', 'Excavación larga y estrecha que se hace en la tierra para echar los cimientos, conducir las aguas, defender los sembríos o usos semejantes.', 138);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('CA010', 'Curva de Nivel', 'Línea que conecta puntos que tienen el mismo valor de altura respecto al datum vertical.', 139);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('CA030', 'Punto Acotado/de Cota', 'Lugar designado con un valor de elevación relativa con respecto a un datum vertical.', 140);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('DB010', 'Acantilado', 'Superficie empinada vertical o dominante de una roca o de la tierra.', 141);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('DB170', 'Duna', 'Uno o varios montículos o lomas de arena por lo general formadas por el viento.', 142);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('DB029', 'Entrada de Cueva', 'Entrada a una serie interconectada de cámaras subterráneas.', 143);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('DB160', 'Estrato Rocoso', 'Importante afloramiento del lecho rocoso expuesto.', 144);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('DB061', 'Grieta', 'Hendidura, fisura, abertura muy fina en la superficie de la tierra, especialmente en la roca.', 145);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BJ099', 'Límite de Nieve', 'Capa permanente de hielo que cubre una extensión de tierra  o  la cima de una montaña.', 146);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('DB090', 'Terraplén', 'Montículo largo de tierra u otro material, realizado por el hombre, que se levanta para hacer una defensa, camino u otra obra semejante.', 147);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('DA010', 'Característica del Suelo', 'Región de la tierra que es homogénea con respecto a una característica del suelo.', 148);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH160', 'Salitral', 'Yacimiento natural cuyo lecho está cubierto con sal  incrustada.', 149);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH150', 'Salina', 'Mina de sal.', 150);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('DB185', 'Cráter', 'Depresión en el terreno en forma cóncava, generalmente redonda y con bordes escarpados.', 151);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AL045', 'Objeto Agregado', 'Lugar que no aparece como un objeto específico, pero con cual la información específica es asociada.', 195);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BJ030', 'Glaciar', 'Gran masa o un río de hielo que se forma por acumulación y  compactación de la nieve en  un terreno alto que se mueve  lentamente por una pendiente o valle por encima de la línea de nieve.', 152);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('EC040', 'Desmonte', 'Zona de terreno donde se ha desbrozado la vegetación; para facilitar principalmente: el acceso de una carretera, ferrocarril, tubería, línea de transmisión eléctrica; demarcar una frontera; obtener línea de vista, o para impedir el progreso de los incendios forestales (un cortafuegos).', 153);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('ZD020', 'Zona sin Información', 'Área que carece de fuentes de cobertura adecuada o donde no se requiere información.', 154);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('EA010', 'Cultivo', 'Área que ha sido labrada para plantar diferentes cosechas; se incluyen terrenos con barbecho.', 155);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('EA030', 'Vivero', 'Lugar donde arbustos, flores, plantas y árboles se cultivan para transplante, semilla o injerto.', 156);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('EB020', 'Matorral', 'Zona cubierta principalmente por especies arbustivas no cultivadas, que están densamente enredadas entre sí.', 157);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('EB010', 'Pastizal', 'Vegetación herbácea o pasto que tienen poco o ningún tejido leñoso.', 158);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('EC005', 'Árbol', 'Planta perenne, de tronco leñoso que crece a una altura considerable y se ramifica a cierta distancia del suelo.', 159);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('EC015', 'Bosque', 'Área con alta densidad de árboles, a veces combinada con maleza y pasto.', 160);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('EC060', 'Claro de Bosque', 'Sitio en un bosque que ha sido limpiado, a menudo por la agricultura de corte, quema y/o como resultado de la tala maderera. También puede producirse por causas naturales, tales como un incendio forestal.', 161);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('EE020', 'Tierra sin Vegetación', 'Una zona con cobertura menor al 5 % o sin vegetación.', 162);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('ED030', 'Zona de Manglar', 'Denso matorral de mangle que está sujeto a inundación por mareas y formación de pantanos.', 163);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('ED020', 'Pantano', 'Terreno húmedo y lodoso, con un drenaje muy pobre, tiene cierto tipo de vegetación acuática y  dificulta el tránsito.', 164);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('FA000', 'Límite Administrativo', 'Límite entre zonas controladas administrativamente.', 165);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('FA001', 'Zona Administrativa', 'Área controlada mediante una autoridad administrativa.', 166);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('ZB030', 'Hito', 'Marca que indica un punto físico sobre la superficie de la tierra cuya posición ha sido medida.', 167);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('IA041', 'Manzana', 'Superficie de terreno o agrupación de lotes cuyo conjunto está delimitado por vías de transito y/o accidentes geográficos naturales.', 168);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('ZB060', 'Vértice Geodésico', 'Punto físico sobre la superficie de la tierra que tiene una posición conocida y se estableció como parte de una red geodésica.', 169);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('GB005', 'Aeropuerto', 'Zona provista de un conjunto de pistas, instalaciones y servicios destinados al tráfico regular de aeronaves.', 170);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('GB015', 'Estacionamiento de Aeronaves', 'Área definida, en un aeródromo terrestre/helipuerto, destinado a acoger aeronaves y helicópteros  para el embarque y desembarque de pasajeros, correo o carga y para abastecerse de combustible, estacionamiento  o mantenimiento.', 171);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('GB035', 'Helipuerto', 'Aeródromo utilizado para aterrizaje y despegue vertical de helicópteros.', 172);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('GB055', 'Pista de Aterrizaje', 'Área rectangular definida en un campo de aviación o aeropuerto, utilizada para despegue y aterrizaje de aeronaves.', 173);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('GB075', 'Pista de Rodadura', 'Ruta definida en un aeródromo, establecido para  el rodaje de aeronaves  y destinada a proporcionar un enlace de movimiento en tierra  entre una parte del aeródromo y otra.', 174);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('SU001', 'Base Militar', 'Conjunto de instalaciones destinadas para el uso militar, que proporcionan apoyo en combate, a fin de que cuenten con las mejores condiciones operativas para el cumplimiento de las tareas asignadas; brindando un soporte  logístico, técnico y de seguridad necesarios.', 175);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AT045', 'Estación de Radar', 'Instalación que utiliza el radar para detectar y analizar objetos (por ejemplo: aviones, buques, satélites artificiales, asteroides, y/o misiles) y/o fenómenos ambientales (por ejemplo: tornados).', 177);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AM065', 'Instalación de Almacenamiento de Municiones', 'Depósito para el almacenamiento y mantenimiento de municiones y explosivos (por ejemplo: bombas, misiles, ojivas, minas o municiones).', 178);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AH070', 'Puesto de Control', 'Lugar donde se registran, declaran y/o inspeccionan bienes y/o personas.', 179);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AL121', 'Zona de Artillería Anti-Aérea', 'Zona de instalaciones relacionadas (por ejemplo: edificios y/o equipos de radar) para el almacenamiento y emplazamiento de artillería anti-aérea.', 180);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('FC050', 'Área de Disparo y/o Práctica Naval', 'Área donde la fuerza naval (por ejemplo:buques o aeronaves) ejecutan ejercicios de disparo de munición  y lanzamiento de misiles en forma real.', 181);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('FA165', 'Área de Entrenamiento', 'Sitio destinado a la instrucción y adiestramiento especializado del personal movilizado para completar las dotaciones de guerra de las unidades y reparticiones del ejercito, así como para proporcionar los reemplazos necesarios a las tropas en combate.', 182);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('FC055', 'Área de Operaciones Navales', 'Área donde la fuerza naval ejecuta operaciones.', 183);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('FC200', 'Campo Minado', 'Parte del terreno sembrado de minas Antitanques y Antipersonal está destinado a retardar, desgastar y encauzar al adversario. En guerra naval es área de mar sembrada de minas antibuque y/o antisubmarinas, con el propósito de impedir el tráfico marítimo enemigo y/o proteger lugares de interés en el litoral, tales como puertos, bahías y canales.', 184);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('FA021', 'Límite Marítimo', 'Línea donde actividades determinadas o ciertos factores aplican tanto para la navegación u operación.', 185);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('FA015', 'Polígono de Tiro', 'Sitio designado con el propósito de disparar municiones y detonar explosivos.', 186);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('FA517', 'Unidad Militar', 'Área que es de responsabilidad de un comando jurisdiccional.', 187);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('FC046', 'Área de un Cuerpo de Agua', 'Cuerpo de agua geográficamente definido (por ejemplo: el mar u otras aguas navegables).', 188);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('ZI015', 'Colección de Nombres', 'Conjunto de nombres geográficos recogidos por una entidad de modelo que los utiliza para denotar una características junto con una ubicación geográfica adecuada para su uso en nomenclátor.', 189);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('DA031', 'Denominación de la Parcela de Tierra', 'Parcela de un territorio natural, definido por sus características geográficas y conocido por su propio nombre.', 190);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('ZD040', 'Nombre de Sitio', 'Sitio geográfico sobre la superficie de la tierra que tiene nombre propio.', 191);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('ZI005', 'Nombre Geográfico', 'Nombre usado para denotar un objeto y la información de relación para establecer el contexto del uso, por parte de una entidad de modelo específica (por ejemplo: base de datos geográfica).', 192);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('DB000', 'Superficie de la Tierra', 'Parte de la tierra geográficamente definida.', 193);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('ZI033', 'Series', 'Para representar las hojas que de acuerdo a la escala se dividen para cubrir el país', 194);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('ZD012', 'Punto de Información Geográfica', 'Región en la que múltiples características que tiene la misma función  se representa como  objeto contiguo agregado.', 196);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AI030', 'Campamento Militar', 'Instalaciones generalmente en terreno abierto que pueden ser movidas con facilidad, sirven como residencia a tiempo completo o temporal.', 176);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BD122', 'Banco de Arena', 'Acumulación de arena, grava o guijarros en el lecho de un río.', 0);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH165', 'Aliviadero', 'Estructura hidráulica destinada a permitir el pase libre o controlado del agua en los escurrimientos superficiales; siendo el aliviadero en exclusiva para el desagüe.', 0);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AQ035', 'Acera', 'Ruta pavimentada o mejorada para uso del peatón, normalmente se encuentra adyacente y paralela a una calle o carretera. ', 197);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AQ037', 'Bordillo', 'Borde de hormigón, asfalto o piedras que forman el borde de una acera a lo largo de la orilla de una calle o carretera. Se debe incluir aquellos que formen parte de los parterres.', 198);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AJ110', 'Invernadero', 'Edificio construido principalmente de material transparente en el que la temperatura y la humedad puede ser controlada para el cultivo y/o protección de plantas.', 199);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('ZB050', 'Punto de Control', 'Objeto en el terreno de ubicación conocida, donde se ha determinado las coordenadas horizontal y/o vertical por métodos geodésicos o topográficos.', 200);


--
-- TOC entry 7341 (class 0 OID 2452419)
-- Dependencies: 316
-- Data for Name: dit; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.dit VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.dit VALUES (1, '1.- Irrigación');
INSERT INTO catalogo_objetos.dit VALUES (2, '2.- Drenaje');
INSERT INTO catalogo_objetos.dit VALUES (3, '3.- Aguas residuales');
INSERT INTO catalogo_objetos.dit VALUES (998, '998.- No aplica');


--
-- TOC entry 7342 (class 0 OID 2452422)
-- Dependencies: 317
-- Data for Name: ela; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.ela VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.ela VALUES (1, '1.- Preciso');
INSERT INTO catalogo_objetos.ela VALUES (2, '2.- Aproximado');
INSERT INTO catalogo_objetos.ela VALUES (998, '998.- No aplica');


--
-- TOC entry 7343 (class 0 OID 2452425)
-- Dependencies: 318
-- Data for Name: fco; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.fco VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.fco VALUES (1, '1.- Disperso');
INSERT INTO catalogo_objetos.fco VALUES (5, '5.- Divido en igual ancho');
INSERT INTO catalogo_objetos.fco VALUES (6, '6.- Dividido en diferente ancho');
INSERT INTO catalogo_objetos.fco VALUES (7, '7.- Sin divisiones');
INSERT INTO catalogo_objetos.fco VALUES (998, '998.- No aplica');


--
-- TOC entry 7344 (class 0 OID 2452428)
-- Dependencies: 319
-- Data for Name: fti; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.fti VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.fti VALUES (1, '1.- Metal');
INSERT INTO catalogo_objetos.fti VALUES (2, '2.- Madera');
INSERT INTO catalogo_objetos.fti VALUES (3, '3.- Mampostería');
INSERT INTO catalogo_objetos.fti VALUES (4, '4.- Roca');
INSERT INTO catalogo_objetos.fti VALUES (5, '5.- Alambre de púas');
INSERT INTO catalogo_objetos.fti VALUES (6, '6.- Malla');
INSERT INTO catalogo_objetos.fti VALUES (7, '7.- Cable electrificado');
INSERT INTO catalogo_objetos.fti VALUES (8, '8.- Geotextil');
INSERT INTO catalogo_objetos.fti VALUES (9, '9.- Redes');
INSERT INTO catalogo_objetos.fti VALUES (998, '998.- No aplica');


--
-- TOC entry 7345 (class 0 OID 2452431)
-- Dependencies: 320
-- Data for Name: fuc; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.fuc VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.fuc VALUES (1, '1.- Industrial');
INSERT INTO catalogo_objetos.fuc VALUES (2, '2.- Comercial');
INSERT INTO catalogo_objetos.fuc VALUES (3, '3.- Institucional');
INSERT INTO catalogo_objetos.fuc VALUES (4, '4.- Residencial');
INSERT INTO catalogo_objetos.fuc VALUES (5, '5.- Agricultura');
INSERT INTO catalogo_objetos.fuc VALUES (6, '6.- Marítimo');
INSERT INTO catalogo_objetos.fuc VALUES (8, '8.- Refugio');
INSERT INTO catalogo_objetos.fuc VALUES (9, '9.- Correccional');
INSERT INTO catalogo_objetos.fuc VALUES (10, '10.- Santuario de vida salvaje');
INSERT INTO catalogo_objetos.fuc VALUES (12, '12.- Reserva');
INSERT INTO catalogo_objetos.fuc VALUES (13, '13.- Recreacional');
INSERT INTO catalogo_objetos.fuc VALUES (19, '19.- Urbanización multifuncional');
INSERT INTO catalogo_objetos.fuc VALUES (20, '20.- Transportación');
INSERT INTO catalogo_objetos.fuc VALUES (23, '23.- Medicina');
INSERT INTO catalogo_objetos.fuc VALUES (24, '24.- Preservación forestal');
INSERT INTO catalogo_objetos.fuc VALUES (26, '26.- Educacional');
INSERT INTO catalogo_objetos.fuc VALUES (27, '27.- No comercial');
INSERT INTO catalogo_objetos.fuc VALUES (31, '31.- Cultural');
INSERT INTO catalogo_objetos.fuc VALUES (32, '32.- Gubernamental');
INSERT INTO catalogo_objetos.fuc VALUES (33, '33.- Área prohibida');
INSERT INTO catalogo_objetos.fuc VALUES (34, '34.- Servicio público');
INSERT INTO catalogo_objetos.fuc VALUES (35, '35.- Religioso');
INSERT INTO catalogo_objetos.fuc VALUES (36, '36.- Seguridad');
INSERT INTO catalogo_objetos.fuc VALUES (37, '37.- Militar');
INSERT INTO catalogo_objetos.fuc VALUES (38, '38.- Empresa de Servicio Público');
INSERT INTO catalogo_objetos.fuc VALUES (39, '39.- Recursos para ingeniería o construcción');
INSERT INTO catalogo_objetos.fuc VALUES (40, '40.- Almacenamiento al granel');
INSERT INTO catalogo_objetos.fuc VALUES (41, '41.- Área de oficina');
INSERT INTO catalogo_objetos.fuc VALUES (42, '42.- Investigación');
INSERT INTO catalogo_objetos.fuc VALUES (998, '998.- No aplica');


--
-- TOC entry 7346 (class 0 OID 2452434)
-- Dependencies: 321
-- Data for Name: hct; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.hct VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.hct VALUES (1, '1.- Ruta primaria');
INSERT INTO catalogo_objetos.hct VALUES (2, '2.- Ruta secundaria');
INSERT INTO catalogo_objetos.hct VALUES (3, '3.- Autopista nacional');
INSERT INTO catalogo_objetos.hct VALUES (4, '4.- Ruta local');
INSERT INTO catalogo_objetos.hct VALUES (998, '998.- No aplica');


--
-- TOC entry 7347 (class 0 OID 2452437)
-- Dependencies: 322
-- Data for Name: hyp; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.hyp VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.hyp VALUES (1, '1.- Perenne');
INSERT INTO catalogo_objetos.hyp VALUES (2, '2.- Intermitente');
INSERT INTO catalogo_objetos.hyp VALUES (3, '3.- Eventual');
INSERT INTO catalogo_objetos.hyp VALUES (4, '4.- Seco');
INSERT INTO catalogo_objetos.hyp VALUES (998, '998.- No aplica');


--
-- TOC entry 7348 (class 0 OID 2452440)
-- Dependencies: 323
-- Data for Name: kos; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.kos VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.kos VALUES (1, '1.- Fútbol');
INSERT INTO catalogo_objetos.kos VALUES (2, '2.- Campo de atletismo');
INSERT INTO catalogo_objetos.kos VALUES (3, '3.- Tenis');
INSERT INTO catalogo_objetos.kos VALUES (4, '4.- Equitación');
INSERT INTO catalogo_objetos.kos VALUES (5, '5.- Natación');
INSERT INTO catalogo_objetos.kos VALUES (6, '6.- Pista de esquí');
INSERT INTO catalogo_objetos.kos VALUES (7, '7.- Patinaje de hielo');
INSERT INTO catalogo_objetos.kos VALUES (8, '8.- Deportes de motor');
INSERT INTO catalogo_objetos.kos VALUES (10, '10.- Carreras de perros');
INSERT INTO catalogo_objetos.kos VALUES (11, '11.- Esquí a campo traviesa');
INSERT INTO catalogo_objetos.kos VALUES (12, '12.- Golf');
INSERT INTO catalogo_objetos.kos VALUES (13, '13.- Navegación a vela');
INSERT INTO catalogo_objetos.kos VALUES (14, '14.- Pista de obstáculos');
INSERT INTO catalogo_objetos.kos VALUES (998, '998.- No aplica');


--
-- TOC entry 7349 (class 0 OID 2452443)
-- Dependencies: 324
-- Data for Name: loc; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.loc VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.loc VALUES (17, '17.- Sobre el fondo de un cuerpo de agua');
INSERT INTO catalogo_objetos.loc VALUES (23, '23.- Bajo el fondo del cuerpo de agua');
INSERT INTO catalogo_objetos.loc VALUES (40, '40.- Bajo la superficie');
INSERT INTO catalogo_objetos.loc VALUES (44, '44.- En la superficie');
INSERT INTO catalogo_objetos.loc VALUES (45, '45.- Sobre la superficie');
INSERT INTO catalogo_objetos.loc VALUES (46, '46.- Sobre el fondo del cuerpo de agua');
INSERT INTO catalogo_objetos.loc VALUES (47, '47.- Bajo la superficie del cuerpo de agua');
INSERT INTO catalogo_objetos.loc VALUES (998, '998.- No aplica');


--
-- TOC entry 7350 (class 0 OID 2452446)
-- Dependencies: 325
-- Data for Name: mes; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.mes VALUES (0, '0.- Falso');
INSERT INTO catalogo_objetos.mes VALUES (1, '1.- Verdadero');


--
-- TOC entry 7351 (class 0 OID 2452449)
-- Dependencies: 326
-- Data for Name: rdt; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.rdt VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.rdt VALUES (2, '2.- Tránsito rápido');
INSERT INTO catalogo_objetos.rdt VALUES (3, '3.- Privada');
INSERT INTO catalogo_objetos.rdt VALUES (4, '4.- Servicio');
INSERT INTO catalogo_objetos.rdt VALUES (5, '5.- Alta velocidad');
INSERT INTO catalogo_objetos.rdt VALUES (6, '6.- Ruta');
INSERT INTO catalogo_objetos.rdt VALUES (7, '7.- Circunvalación');
INSERT INTO catalogo_objetos.rdt VALUES (11, '11.- Camino corto');
INSERT INTO catalogo_objetos.rdt VALUES (45, '45.- Camino de herradura');
INSERT INTO catalogo_objetos.rdt VALUES (46, '46.- Cruce/intersección de caminos');
INSERT INTO catalogo_objetos.rdt VALUES (998, '998.- No aplica');


--
-- TOC entry 7352 (class 0 OID 2452452)
-- Dependencies: 327
-- Data for Name: rel; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.rel VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.rel VALUES (1, '1.- Budismo');
INSERT INTO catalogo_objetos.rel VALUES (2, '2.- Islam');
INSERT INTO catalogo_objetos.rel VALUES (3, '3.- Católica Romana');
INSERT INTO catalogo_objetos.rel VALUES (4, '4.- Cristiana');
INSERT INTO catalogo_objetos.rel VALUES (5, '5.- Judaísmo');
INSERT INTO catalogo_objetos.rel VALUES (6, '6.- Ortodoxa');
INSERT INTO catalogo_objetos.rel VALUES (7, '7.- Protestante');
INSERT INTO catalogo_objetos.rel VALUES (8, '8.- Sintoísmo');
INSERT INTO catalogo_objetos.rel VALUES (9, '9.- Hinduismo');
INSERT INTO catalogo_objetos.rel VALUES (10, '10.- Chiísmo');
INSERT INTO catalogo_objetos.rel VALUES (11, '11.- Suníes');
INSERT INTO catalogo_objetos.rel VALUES (12, '12.- Nestoriana');
INSERT INTO catalogo_objetos.rel VALUES (13, '13.- Caldea');
INSERT INTO catalogo_objetos.rel VALUES (15, '15.- Religión tribal');
INSERT INTO catalogo_objetos.rel VALUES (998, '998.- No aplica');


--
-- TOC entry 7353 (class 0 OID 2452455)
-- Dependencies: 328
-- Data for Name: rgc; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.rgc VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.rgc VALUES (1, '1.- Amplia');
INSERT INTO catalogo_objetos.rgc VALUES (2, '2.- Angosta/estrecha');
INSERT INTO catalogo_objetos.rgc VALUES (3, '3.- Estándar/normal');
INSERT INTO catalogo_objetos.rgc VALUES (6, '6.- Monocarril');
INSERT INTO catalogo_objetos.rgc VALUES (998, '998.- No aplica');


--
-- TOC entry 7354 (class 0 OID 2452458)
-- Dependencies: 329
-- Data for Name: rra; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.rra VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.rra VALUES (1, '1.- Carril electrificado');
INSERT INTO catalogo_objetos.rra VALUES (3, '3.- Electrificación aérea');
INSERT INTO catalogo_objetos.rra VALUES (4, '4.- No electrificada');
INSERT INTO catalogo_objetos.rra VALUES (998, '998.- No aplica');


--
-- TOC entry 7355 (class 0 OID 2452461)
-- Dependencies: 330
-- Data for Name: rrc; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.rrc VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.rrc VALUES (2, '2.- Carline');
INSERT INTO catalogo_objetos.rrc VALUES (6, '6.- Ferrocarril subterráneo');
INSERT INTO catalogo_objetos.rrc VALUES (8, '8.- Transporte para madera');
INSERT INTO catalogo_objetos.rrc VALUES (10, '10.- Miniatura');
INSERT INTO catalogo_objetos.rrc VALUES (11, '11.- Tránsito rápido (Metro)');
INSERT INTO catalogo_objetos.rrc VALUES (13, '13.- Ferrocarril ayuda marina');
INSERT INTO catalogo_objetos.rrc VALUES (14, '14.- Tranvía');
INSERT INTO catalogo_objetos.rrc VALUES (15, '15.- Funicular');
INSERT INTO catalogo_objetos.rrc VALUES (24, '24.- Museo');
INSERT INTO catalogo_objetos.rrc VALUES (32, '32.- Sistema de tránsito automatizado');
INSERT INTO catalogo_objetos.rrc VALUES (33, '33.- Larga distancia');
INSERT INTO catalogo_objetos.rrc VALUES (998, '998.-  No aplica');


--
-- TOC entry 7356 (class 0 OID 2452464)
-- Dependencies: 331
-- Data for Name: rst; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.rst VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.rst VALUES (1, '1.- Duro/pavimentado');
INSERT INTO catalogo_objetos.rst VALUES (2, '2.- Suelto/no pavimentado');
INSERT INTO catalogo_objetos.rst VALUES (3, '3.- Suelto/ligero');
INSERT INTO catalogo_objetos.rst VALUES (4, '4.- Troncos entrecruzados');
INSERT INTO catalogo_objetos.rst VALUES (5, '5.- Hierba/césped');
INSERT INTO catalogo_objetos.rst VALUES (6, '6.- Sin mejoras');
INSERT INTO catalogo_objetos.rst VALUES (7, '7.- Permanente');
INSERT INTO catalogo_objetos.rst VALUES (8, '8.- Temporal');
INSERT INTO catalogo_objetos.rst VALUES (9, '9.- Composición dura');
INSERT INTO catalogo_objetos.rst VALUES (10, '10.- PEM');
INSERT INTO catalogo_objetos.rst VALUES (11, '11.- Bituminosas');
INSERT INTO catalogo_objetos.rst VALUES (12, '12.- Composición suave');
INSERT INTO catalogo_objetos.rst VALUES (13, '13.- Tierra clasificada');
INSERT INTO catalogo_objetos.rst VALUES (14, '14.- Tierra sin clasificar');
INSERT INTO catalogo_objetos.rst VALUES (15, '15.- Hielo');
INSERT INTO catalogo_objetos.rst VALUES (16, '16.- Nieve');
INSERT INTO catalogo_objetos.rst VALUES (17, '17.- Macadán');
INSERT INTO catalogo_objetos.rst VALUES (18, '18.- Membrana');
INSERT INTO catalogo_objetos.rst VALUES (19, '19.- Mezcla');
INSERT INTO catalogo_objetos.rst VALUES (20, '20.- Laterita');
INSERT INTO catalogo_objetos.rst VALUES (21, '21.- Arena');
INSERT INTO catalogo_objetos.rst VALUES (22, '22.- Asfalto sobre concreto');
INSERT INTO catalogo_objetos.rst VALUES (23, '23.- Encofrado de acero perforado');
INSERT INTO catalogo_objetos.rst VALUES (24, '24.- Grava');
INSERT INTO catalogo_objetos.rst VALUES (25, '25.- Coral');
INSERT INTO catalogo_objetos.rst VALUES (26, '26.- Arcilla');
INSERT INTO catalogo_objetos.rst VALUES (27, '27.- Concreto');
INSERT INTO catalogo_objetos.rst VALUES (28, '28.- Ladrillo');
INSERT INTO catalogo_objetos.rst VALUES (29, '29.- Asfáltica');
INSERT INTO catalogo_objetos.rst VALUES (30, '30.- Ceniza');
INSERT INTO catalogo_objetos.rst VALUES (31, '31.- Empedrada');
INSERT INTO catalogo_objetos.rst VALUES (32, '32.- Concha');
INSERT INTO catalogo_objetos.rst VALUES (33, '33.- Tablón de madera');
INSERT INTO catalogo_objetos.rst VALUES (998, '998.- No aplica');


--
-- TOC entry 7357 (class 0 OID 2452467)
-- Dependencies: 332
-- Data for Name: slt; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.slt VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.slt VALUES (6, '6.- Manglar');
INSERT INTO catalogo_objetos.slt VALUES (8, '8.- Pantano');
INSERT INTO catalogo_objetos.slt VALUES (11, '11.- Escombros de construcción');
INSERT INTO catalogo_objetos.slt VALUES (12, '12.- Escombros de erosión');
INSERT INTO catalogo_objetos.slt VALUES (13, '13.- Arenoso');
INSERT INTO catalogo_objetos.slt VALUES (14, '14.- Guijarros');
INSERT INTO catalogo_objetos.slt VALUES (15, '15.- Rocoso');
INSERT INTO catalogo_objetos.slt VALUES (16, '16.- Coral');
INSERT INTO catalogo_objetos.slt VALUES (17, '17.- Hielo');
INSERT INTO catalogo_objetos.slt VALUES (18, '18.- Barro');
INSERT INTO catalogo_objetos.slt VALUES (998, '998.- No aplica');


--
-- TOC entry 7358 (class 0 OID 2452470)
-- Dependencies: 333
-- Data for Name: smc; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.smc VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.smc VALUES (2, '2.- Aluminio');
INSERT INTO catalogo_objetos.smc VALUES (4, '4.- Ceniza');
INSERT INTO catalogo_objetos.smc VALUES (5, '5.- Asfalto');
INSERT INTO catalogo_objetos.smc VALUES (6, '6.- Basalto');
INSERT INTO catalogo_objetos.smc VALUES (7, '7.- Roca Madre');
INSERT INTO catalogo_objetos.smc VALUES (8, '8.- Cantos Rodados');
INSERT INTO catalogo_objetos.smc VALUES (9, '9.- Ladrillo');
INSERT INTO catalogo_objetos.smc VALUES (10, '10.- Calcáreo');
INSERT INTO catalogo_objetos.smc VALUES (12, '12.- Tiza');
INSERT INTO catalogo_objetos.smc VALUES (14, '14.- Cenizas');
INSERT INTO catalogo_objetos.smc VALUES (15, '15.- Cirripedia');
INSERT INTO catalogo_objetos.smc VALUES (16, '16.- Arcilla');
INSERT INTO catalogo_objetos.smc VALUES (17, '17.- Carbón');
INSERT INTO catalogo_objetos.smc VALUES (18, '18.- Empedrado');
INSERT INTO catalogo_objetos.smc VALUES (19, '19.- Coque');
INSERT INTO catalogo_objetos.smc VALUES (20, '20.- Composición');
INSERT INTO catalogo_objetos.smc VALUES (21, '21.- Concreto u Hormigón');
INSERT INTO catalogo_objetos.smc VALUES (22, '22.- Conglomerado');
INSERT INTO catalogo_objetos.smc VALUES (23, '23.- Cobre');
INSERT INTO catalogo_objetos.smc VALUES (24, '24.- Coral');
INSERT INTO catalogo_objetos.smc VALUES (25, '25.- Coral Head');
INSERT INTO catalogo_objetos.smc VALUES (28, '28.- Tierra de diatomeas');
INSERT INTO catalogo_objetos.smc VALUES (29, '29.- Dolomita');
INSERT INTO catalogo_objetos.smc VALUES (34, '34.- Flysch');
INSERT INTO catalogo_objetos.smc VALUES (36, '36.- Foraminíferos');
INSERT INTO catalogo_objetos.smc VALUES (37, '37.- Fucus');
INSERT INTO catalogo_objetos.smc VALUES (40, '40.- Vidrio');
INSERT INTO catalogo_objetos.smc VALUES (42, '42.- Oro');
INSERT INTO catalogo_objetos.smc VALUES (43, '43.- Granito');
INSERT INTO catalogo_objetos.smc VALUES (45, '45.- Materia vegetal');
INSERT INTO catalogo_objetos.smc VALUES (46, '46.- Grava');
INSERT INTO catalogo_objetos.smc VALUES (47, '47.- Rocaverde (Jade)');
INSERT INTO catalogo_objetos.smc VALUES (49, '49.- Suelo  de conchas');
INSERT INTO catalogo_objetos.smc VALUES (51, '51.- Hierro');
INSERT INTO catalogo_objetos.smc VALUES (52, '52.- Lava');
INSERT INTO catalogo_objetos.smc VALUES (54, '54.- Plomo');
INSERT INTO catalogo_objetos.smc VALUES (55, '55.- Loess');
INSERT INTO catalogo_objetos.smc VALUES (56, '56.- Maderos');
INSERT INTO catalogo_objetos.smc VALUES (57, '57.- Macadán');
INSERT INTO catalogo_objetos.smc VALUES (58, '58.- Madrépora');
INSERT INTO catalogo_objetos.smc VALUES (59, '59.- Manganeso');
INSERT INTO catalogo_objetos.smc VALUES (60, '60.- Mármol');
INSERT INTO catalogo_objetos.smc VALUES (61, '61.- Marga');
INSERT INTO catalogo_objetos.smc VALUES (62, '62.- Mampostería');
INSERT INTO catalogo_objetos.smc VALUES (63, '63.- Mate');
INSERT INTO catalogo_objetos.smc VALUES (64, '64.- Metal');
INSERT INTO catalogo_objetos.smc VALUES (65, '65.- Barro');
INSERT INTO catalogo_objetos.smc VALUES (66, '66.- Mejillones');
INSERT INTO catalogo_objetos.smc VALUES (67, '67.- Aceite');
INSERT INTO catalogo_objetos.smc VALUES (69, '69.- Cieno');
INSERT INTO catalogo_objetos.smc VALUES (70, '70.- Ostras');
INSERT INTO catalogo_objetos.smc VALUES (71, '71.- Papel');
INSERT INTO catalogo_objetos.smc VALUES (72, '72.- Parte  Metálica');
INSERT INTO catalogo_objetos.smc VALUES (73, '73.- Guijarros');
INSERT INTO catalogo_objetos.smc VALUES (74, '74.- Plástico');
INSERT INTO catalogo_objetos.smc VALUES (75, '75.- Algas marinas');
INSERT INTO catalogo_objetos.smc VALUES (76, '76.- Pórfido');
INSERT INTO catalogo_objetos.smc VALUES (77, '77.- Hormigón pretensado');
INSERT INTO catalogo_objetos.smc VALUES (79, '79.- Piedra Pómez');
INSERT INTO catalogo_objetos.smc VALUES (80, '80.- Cuarzo');
INSERT INTO catalogo_objetos.smc VALUES (81, '81.- Radiolario');
INSERT INTO catalogo_objetos.smc VALUES (82, '82.- Material radiactivo');
INSERT INTO catalogo_objetos.smc VALUES (83, '83.- Hormigón armado');
INSERT INTO catalogo_objetos.smc VALUES (84, '84.- Piedras');
INSERT INTO catalogo_objetos.smc VALUES (85, '85.- Caucho');
INSERT INTO catalogo_objetos.smc VALUES (86, '86.- Escombros');
INSERT INTO catalogo_objetos.smc VALUES (87, '87.- Sal');
INSERT INTO catalogo_objetos.smc VALUES (88, '88.- Arena');
INSERT INTO catalogo_objetos.smc VALUES (89, '89.- Arenisca');
INSERT INTO catalogo_objetos.smc VALUES (90, '90.- Esquisto');
INSERT INTO catalogo_objetos.smc VALUES (91, '91.- Desperdicio de minas');
INSERT INTO catalogo_objetos.smc VALUES (92, '92.- Escoria');
INSERT INTO catalogo_objetos.smc VALUES (95, '95.- Aguas Residuales');
INSERT INTO catalogo_objetos.smc VALUES (96, '96.- Concha');
INSERT INTO catalogo_objetos.smc VALUES (98, '98.- Guijarro');
INSERT INTO catalogo_objetos.smc VALUES (99, '99.- Limo');
INSERT INTO catalogo_objetos.smc VALUES (100, '100.- Plata');
INSERT INTO catalogo_objetos.smc VALUES (101, '101.- Desechos de metales');
INSERT INTO catalogo_objetos.smc VALUES (102, '102.- Lodos');
INSERT INTO catalogo_objetos.smc VALUES (103, '103.- Agua congelada');
INSERT INTO catalogo_objetos.smc VALUES (104, '104.- Suelo');
INSERT INTO catalogo_objetos.smc VALUES (105, '105.- Espículas');
INSERT INTO catalogo_objetos.smc VALUES (106, '106.- Esponja');
INSERT INTO catalogo_objetos.smc VALUES (107, '107.- Acero');
INSERT INTO catalogo_objetos.smc VALUES (108, '108.- Piedra preciosa');
INSERT INTO catalogo_objetos.smc VALUES (110, '110.- Travertino');
INSERT INTO catalogo_objetos.smc VALUES (111, '111.- Toba');
INSERT INTO catalogo_objetos.smc VALUES (112, '112.- Mineral de  uranio');
INSERT INTO catalogo_objetos.smc VALUES (113, '113.- Vegetación');
INSERT INTO catalogo_objetos.smc VALUES (115, '115.- Ceniza Volcánica');
INSERT INTO catalogo_objetos.smc VALUES (116, '116.- Agua');
INSERT INTO catalogo_objetos.smc VALUES (117, '117.- Madera');
INSERT INTO catalogo_objetos.smc VALUES (118, '118.- Zinc');
INSERT INTO catalogo_objetos.smc VALUES (120, '120.- Arena y Grava');
INSERT INTO catalogo_objetos.smc VALUES (121, '121.- Escollera');
INSERT INTO catalogo_objetos.smc VALUES (122, '122.- Evaporita');
INSERT INTO catalogo_objetos.smc VALUES (124, '124.- Arena y rocas');
INSERT INTO catalogo_objetos.smc VALUES (126, '126.- Arena y barro');
INSERT INTO catalogo_objetos.smc VALUES (128, '128.- Plástico reforzado con vidrio (GRP)');
INSERT INTO catalogo_objetos.smc VALUES (129, '129.- Roca metomórfica');
INSERT INTO catalogo_objetos.smc VALUES (130, '130.- Roca  ígnea');
INSERT INTO catalogo_objetos.smc VALUES (131, '131.- Dolerita');
INSERT INTO catalogo_objetos.smc VALUES (205, '205.- Pintura');
INSERT INTO catalogo_objetos.smc VALUES (257, '257.- Hielo');
INSERT INTO catalogo_objetos.smc VALUES (258, '258.- Nieve');
INSERT INTO catalogo_objetos.smc VALUES (262, '262.- Laterita');
INSERT INTO catalogo_objetos.smc VALUES (266, '266.- Breccia');
INSERT INTO catalogo_objetos.smc VALUES (267, '267.- Cerámica');
INSERT INTO catalogo_objetos.smc VALUES (268, '268.- Gneis');
INSERT INTO catalogo_objetos.smc VALUES (269, '269.- Caliza');
INSERT INTO catalogo_objetos.smc VALUES (270, '270.- Cuarcita');
INSERT INTO catalogo_objetos.smc VALUES (271, '271.- Teja');
INSERT INTO catalogo_objetos.smc VALUES (272, '272.- Lutita – esquisto');
INSERT INTO catalogo_objetos.smc VALUES (273, '273.- Pizarra');
INSERT INTO catalogo_objetos.smc VALUES (274, '274.- Césped');
INSERT INTO catalogo_objetos.smc VALUES (275, '275.- Paja');
INSERT INTO catalogo_objetos.smc VALUES (276, '276.- Madero');
INSERT INTO catalogo_objetos.smc VALUES (277, '277.- Roca sedimentaria');
INSERT INTO catalogo_objetos.smc VALUES (278, '278.- Adobe');
INSERT INTO catalogo_objetos.smc VALUES (279, '279.- Madera tratada');
INSERT INTO catalogo_objetos.smc VALUES (280, '280.- Pasto');
INSERT INTO catalogo_objetos.smc VALUES (998, '998.- No aplica');


--
-- TOC entry 7359 (class 0 OID 2452473)
-- Dependencies: 334
-- Data for Name: tra; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.tra VALUES (0, '0.- Falso');
INSERT INTO catalogo_objetos.tra VALUES (1, '1.- Verdadero');


--
-- TOC entry 7360 (class 0 OID 2452476)
-- Dependencies: 335
-- Data for Name: tuc; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.tuc VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.tuc VALUES (19, '19.- Ganadería');
INSERT INTO catalogo_objetos.tuc VALUES (25, '25.- Carga');
INSERT INTO catalogo_objetos.tuc VALUES (26, '26.- Pasajeros');
INSERT INTO catalogo_objetos.tuc VALUES (33, '33.- Minerales');
INSERT INTO catalogo_objetos.tuc VALUES (35, '35.- No para transporte');
INSERT INTO catalogo_objetos.tuc VALUES (45, '45.- General');
INSERT INTO catalogo_objetos.tuc VALUES (998, '998.- No aplica');


--
-- TOC entry 7361 (class 0 OID 2452479)
-- Dependencies: 336
-- Data for Name: typ; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.typ VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.typ VALUES (1, '1.- Carretera');
INSERT INTO catalogo_objetos.typ VALUES (5, '5.- Bulevar');
INSERT INTO catalogo_objetos.typ VALUES (9, '9.- Avenida');
INSERT INTO catalogo_objetos.typ VALUES (13, '13.- Paseo');
INSERT INTO catalogo_objetos.typ VALUES (17, '17.- Curva de retorno');
INSERT INTO catalogo_objetos.typ VALUES (21, '21.- Cerrada');
INSERT INTO catalogo_objetos.typ VALUES (25, '25.- Ruta verde (Parkway)');
INSERT INTO catalogo_objetos.typ VALUES (29, '29.- Pasaje');
INSERT INTO catalogo_objetos.typ VALUES (33, '33.- Calle');
INSERT INTO catalogo_objetos.typ VALUES (37, '37.- Terraza');
INSERT INTO catalogo_objetos.typ VALUES (41, '41.- Autopista');
INSERT INTO catalogo_objetos.typ VALUES (45, '45.- Plaza');
INSERT INTO catalogo_objetos.typ VALUES (46, '46.- Rodera');
INSERT INTO catalogo_objetos.typ VALUES (47, '47.- Autopista de acceso restringido');
INSERT INTO catalogo_objetos.typ VALUES (48, '48.- Redondel');
INSERT INTO catalogo_objetos.typ VALUES (49, '49.- Sendero');
INSERT INTO catalogo_objetos.typ VALUES (50, '50.- Rampa');
INSERT INTO catalogo_objetos.typ VALUES (998, '998.- No aplica');


--
-- TOC entry 7362 (class 0 OID 2452482)
-- Dependencies: 337
-- Data for Name: uuc; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.uuc VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.uuc VALUES (4, '4.- Transformador');
INSERT INTO catalogo_objetos.uuc VALUES (5, '5.- Desagüe');
INSERT INTO catalogo_objetos.uuc VALUES (6, '6.- Represa');
INSERT INTO catalogo_objetos.uuc VALUES (7, '7.- Agua potable');
INSERT INTO catalogo_objetos.uuc VALUES (9, '9.- Dependencia');
INSERT INTO catalogo_objetos.uuc VALUES (10, '10.- Central eléctrica');
INSERT INTO catalogo_objetos.uuc VALUES (11, '11.- Planta de filtración');
INSERT INTO catalogo_objetos.uuc VALUES (12, '12.- Refrigeración');
INSERT INTO catalogo_objetos.uuc VALUES (18, '18.- Central de abastecimiento de agua');
INSERT INTO catalogo_objetos.uuc VALUES (998, '998.- No aplica');


--
-- TOC entry 7363 (class 0 OID 2452485)
-- Dependencies: 338
-- Data for Name: wtc; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.wtc VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.wtc VALUES (1, '1.- Todo el tiempo (todo el año)');
INSERT INTO catalogo_objetos.wtc VALUES (3, '3.- Solamente en invierno');
INSERT INTO catalogo_objetos.wtc VALUES (4, '4.- Limitada todo el tiempo');
INSERT INTO catalogo_objetos.wtc VALUES (5, '5.- Cerrada en invierno');
INSERT INTO catalogo_objetos.wtc VALUES (998, '998.- No aplica');
INSERT INTO catalogo_objetos.wtc VALUES (2, '2.- Buen clima (época seca)');


--
-- TOC entry 7364 (class 0 OID 2452488)
-- Dependencies: 339
-- Data for Name: wti; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.wti VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.wti VALUES (1, '1.- Independiente');
INSERT INTO catalogo_objetos.wti VALUES (2, '2.- Retener (obstaculizar)');
INSERT INTO catalogo_objetos.wti VALUES (4, '4.- Cercado con árboles');
INSERT INTO catalogo_objetos.wti VALUES (5, '5.- Cerramiento');
INSERT INTO catalogo_objetos.wti VALUES (998, '998.- No aplica');


--
-- TOC entry 7365 (class 0 OID 2452491)
-- Dependencies: 340
-- Data for Name: punto_control_p; Type: TABLE DATA; Schema: d_linderos_propiedad; Owner: postgres
--



--
-- TOC entry 7367 (class 0 OID 2452503)
-- Dependencies: 342
-- Data for Name: cementerio_a; Type: TABLE DATA; Schema: gs_asociado_poblados; Owner: postgres
--



--
-- TOC entry 7369 (class 0 OID 2452515)
-- Dependencies: 344
-- Data for Name: cerca_l; Type: TABLE DATA; Schema: gs_asociado_poblados; Owner: postgres
--



--
-- TOC entry 7371 (class 0 OID 2452527)
-- Dependencies: 346
-- Data for Name: escalinata_a; Type: TABLE DATA; Schema: gs_asociado_poblados; Owner: postgres
--



--
-- TOC entry 7373 (class 0 OID 2452539)
-- Dependencies: 348
-- Data for Name: muro_l; Type: TABLE DATA; Schema: gs_asociado_poblados; Owner: postgres
--



--
-- TOC entry 7375 (class 0 OID 2452551)
-- Dependencies: 350
-- Data for Name: plaza_publica_a; Type: TABLE DATA; Schema: gs_asociado_poblados; Owner: postgres
--



--
-- TOC entry 7377 (class 0 OID 2452563)
-- Dependencies: 352
-- Data for Name: edificio_a; Type: TABLE DATA; Schema: gs_construcciones; Owner: postgres
--



--
-- TOC entry 7379 (class 0 OID 2452575)
-- Dependencies: 354
-- Data for Name: cancha_a; Type: TABLE DATA; Schema: gs_recreacion; Owner: postgres
--



--
-- TOC entry 7381 (class 0 OID 2452587)
-- Dependencies: 356
-- Data for Name: estadio_a; Type: TABLE DATA; Schema: gs_recreacion; Owner: postgres
--



--
-- TOC entry 7383 (class 0 OID 2452599)
-- Dependencies: 358
-- Data for Name: parque_a; Type: TABLE DATA; Schema: gs_recreacion; Owner: postgres
--



--
-- TOC entry 7385 (class 0 OID 2452611)
-- Dependencies: 360
-- Data for Name: piscina_a; Type: TABLE DATA; Schema: gs_recreacion; Owner: postgres
--



--
-- TOC entry 7387 (class 0 OID 2452623)
-- Dependencies: 362
-- Data for Name: plaza_toros_a; Type: TABLE DATA; Schema: gs_recreacion; Owner: postgres
--



--
-- TOC entry 7389 (class 0 OID 2452635)
-- Dependencies: 364
-- Data for Name: acequia_l; Type: TABLE DATA; Schema: ho_aguas_interiores; Owner: postgres
--



--
-- TOC entry 7391 (class 0 OID 2452647)
-- Dependencies: 366
-- Data for Name: acueducto_canal_a; Type: TABLE DATA; Schema: ho_aguas_interiores; Owner: postgres
--



--
-- TOC entry 7393 (class 0 OID 2452659)
-- Dependencies: 368
-- Data for Name: lago_laguna_a; Type: TABLE DATA; Schema: ho_aguas_interiores; Owner: postgres
--



--
-- TOC entry 7395 (class 0 OID 2452671)
-- Dependencies: 370
-- Data for Name: rio_a; Type: TABLE DATA; Schema: ho_aguas_interiores; Owner: postgres
--



--
-- TOC entry 7397 (class 0 OID 2452683)
-- Dependencies: 372
-- Data for Name: rio_l; Type: TABLE DATA; Schema: ho_aguas_interiores; Owner: postgres
--



--
-- TOC entry 7399 (class 0 OID 2452695)
-- Dependencies: 374
-- Data for Name: zanja_l; Type: TABLE DATA; Schema: ho_aguas_interiores; Owner: postgres
--



--
-- TOC entry 7401 (class 0 OID 2452707)
-- Dependencies: 376
-- Data for Name: puerto_a; Type: TABLE DATA; Schema: ho_puertos_muelles; Owner: postgres
--



--
-- TOC entry 7403 (class 0 OID 2452719)
-- Dependencies: 378
-- Data for Name: granja_acuatica_a; Type: TABLE DATA; Schema: ho_regulacion_zonas_restringidas; Owner: postgres
--



--
-- TOC entry 7405 (class 0 OID 2452731)
-- Dependencies: 380
-- Data for Name: isla_a; Type: TABLE DATA; Schema: ho_zonas_costeras; Owner: postgres
--



--
-- TOC entry 7407 (class 0 OID 2452743)
-- Dependencies: 382
-- Data for Name: orilla_l; Type: TABLE DATA; Schema: ho_zonas_costeras; Owner: postgres
--



--
-- TOC entry 7409 (class 0 OID 2452755)
-- Dependencies: 384
-- Data for Name: invernadero_a; Type: TABLE DATA; Schema: ii_agropecuaria; Owner: postgres
--



--
-- TOC entry 7411 (class 0 OID 2452768)
-- Dependencies: 386
-- Data for Name: acera_a; Type: TABLE DATA; Schema: it_asociado_transportacion; Owner: postgres
--



--
-- TOC entry 7413 (class 0 OID 2452780)
-- Dependencies: 388
-- Data for Name: bordillo_l; Type: TABLE DATA; Schema: it_asociado_transportacion; Owner: postgres
--



--
-- TOC entry 7415 (class 0 OID 2452792)
-- Dependencies: 390
-- Data for Name: cuneta_a; Type: TABLE DATA; Schema: it_asociado_transportacion; Owner: postgres
--



--
-- TOC entry 7417 (class 0 OID 2452804)
-- Dependencies: 392
-- Data for Name: parqueadero_a; Type: TABLE DATA; Schema: it_asociado_transportacion; Owner: postgres
--



--
-- TOC entry 7419 (class 0 OID 2452816)
-- Dependencies: 394
-- Data for Name: paseo_peatonal_ciclovia_a; Type: TABLE DATA; Schema: it_asociado_transportacion; Owner: postgres
--



--
-- TOC entry 7421 (class 0 OID 2452828)
-- Dependencies: 396
-- Data for Name: tunel_a; Type: TABLE DATA; Schema: it_asociado_transportacion; Owner: postgres
--



--
-- TOC entry 7423 (class 0 OID 2452840)
-- Dependencies: 398
-- Data for Name: puente_a; Type: TABLE DATA; Schema: it_cruces_enlaces; Owner: postgres
--



--
-- TOC entry 7425 (class 0 OID 2452852)
-- Dependencies: 400
-- Data for Name: ferrocarril_a; Type: TABLE DATA; Schema: it_ferrocarriles; Owner: postgres
--



--
-- TOC entry 7427 (class 0 OID 2452864)
-- Dependencies: 402
-- Data for Name: gasolinera_a; Type: TABLE DATA; Schema: it_transporte_terrestre; Owner: postgres
--



--
-- TOC entry 7429 (class 0 OID 2452876)
-- Dependencies: 404
-- Data for Name: intercambiador_vial_a; Type: TABLE DATA; Schema: it_transporte_terrestre; Owner: postgres
--



--
-- TOC entry 7431 (class 0 OID 2452888)
-- Dependencies: 406
-- Data for Name: rodera_l; Type: TABLE DATA; Schema: it_transporte_terrestre; Owner: postgres
--



--
-- TOC entry 7433 (class 0 OID 2452900)
-- Dependencies: 408
-- Data for Name: sendero_l; Type: TABLE DATA; Schema: it_transporte_terrestre; Owner: postgres
--



--
-- TOC entry 7435 (class 0 OID 2452912)
-- Dependencies: 410
-- Data for Name: via_ruta_a; Type: TABLE DATA; Schema: it_transporte_terrestre; Owner: postgres
--



--
-- TOC entry 7437 (class 0 OID 2452924)
-- Dependencies: 412
-- Data for Name: qgis_projects; Type: TABLE DATA; Schema: proyecto_qgis3; Owner: postgres
--

INSERT INTO proyecto_qgis3.qgis_projects VALUES ('CARTOGRAFIA BASE CATASTRAL', '{"last_modified_time": "2022-06-27 20:40:14.154599", "last_modified_user": "postgres"}', '\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');


--
-- TOC entry 6391 (class 0 OID 16696)
-- Dependencies: 237
-- Data for Name: spatial_ref_sys; Type: TABLE DATA; Schema: public; Owner: postgres
--

--
-- TOC entry 7526 (class 0 OID 0)
-- Dependencies: 310
-- Name: aeropuerto_a_gid_seq; Type: SEQUENCE SET; Schema: a_aeropuerto_superficie; Owner: postgres
--

SELECT pg_catalog.setval('a_aeropuerto_superficie.aeropuerto_a_gid_seq', 7, true);


--
-- TOC entry 7527 (class 0 OID 0)
-- Dependencies: 315
-- Name: catalogo_objetos_gid_seq; Type: SEQUENCE SET; Schema: catalogo_objetos; Owner: postgres
--

SELECT pg_catalog.setval('catalogo_objetos.catalogo_objetos_gid_seq', 200, true);


--
-- TOC entry 7528 (class 0 OID 0)
-- Dependencies: 341
-- Name: vertice_geodesico_p_gid_seq; Type: SEQUENCE SET; Schema: d_linderos_propiedad; Owner: postgres
--

SELECT pg_catalog.setval('d_linderos_propiedad.vertice_geodesico_p_gid_seq', 1, true);


--
-- TOC entry 7529 (class 0 OID 0)
-- Dependencies: 343
-- Name: cementerio_a_gid_seq; Type: SEQUENCE SET; Schema: gs_asociado_poblados; Owner: postgres
--

SELECT pg_catalog.setval('gs_asociado_poblados.cementerio_a_gid_seq', 1, false);


--
-- TOC entry 7530 (class 0 OID 0)
-- Dependencies: 345
-- Name: cerca_l_gid_seq; Type: SEQUENCE SET; Schema: gs_asociado_poblados; Owner: postgres
--

SELECT pg_catalog.setval('gs_asociado_poblados.cerca_l_gid_seq', 1, false);


--
-- TOC entry 7531 (class 0 OID 0)
-- Dependencies: 347
-- Name: escalinata_a_gid_seq; Type: SEQUENCE SET; Schema: gs_asociado_poblados; Owner: postgres
--

SELECT pg_catalog.setval('gs_asociado_poblados.escalinata_a_gid_seq', 1, false);


--
-- TOC entry 7532 (class 0 OID 0)
-- Dependencies: 349
-- Name: muro_l_gid_seq; Type: SEQUENCE SET; Schema: gs_asociado_poblados; Owner: postgres
--

SELECT pg_catalog.setval('gs_asociado_poblados.muro_l_gid_seq', 1, false);


--
-- TOC entry 7533 (class 0 OID 0)
-- Dependencies: 351
-- Name: plaza_publica_a_gid_seq; Type: SEQUENCE SET; Schema: gs_asociado_poblados; Owner: postgres
--

SELECT pg_catalog.setval('gs_asociado_poblados.plaza_publica_a_gid_seq', 1, false);


--
-- TOC entry 7534 (class 0 OID 0)
-- Dependencies: 353
-- Name: edificio_a_gid_seq; Type: SEQUENCE SET; Schema: gs_construcciones; Owner: postgres
--

SELECT pg_catalog.setval('gs_construcciones.edificio_a_gid_seq', 1, false);


--
-- TOC entry 7535 (class 0 OID 0)
-- Dependencies: 355
-- Name: cancha_a_gid_seq; Type: SEQUENCE SET; Schema: gs_recreacion; Owner: postgres
--

SELECT pg_catalog.setval('gs_recreacion.cancha_a_gid_seq', 1, false);


--
-- TOC entry 7536 (class 0 OID 0)
-- Dependencies: 357
-- Name: estadio_a_gid_seq; Type: SEQUENCE SET; Schema: gs_recreacion; Owner: postgres
--

SELECT pg_catalog.setval('gs_recreacion.estadio_a_gid_seq', 1, false);


--
-- TOC entry 7537 (class 0 OID 0)
-- Dependencies: 359
-- Name: parque_a_gid_seq; Type: SEQUENCE SET; Schema: gs_recreacion; Owner: postgres
--

SELECT pg_catalog.setval('gs_recreacion.parque_a_gid_seq', 1, false);


--
-- TOC entry 7538 (class 0 OID 0)
-- Dependencies: 361
-- Name: piscina_a_gid_seq; Type: SEQUENCE SET; Schema: gs_recreacion; Owner: postgres
--

SELECT pg_catalog.setval('gs_recreacion.piscina_a_gid_seq', 1, false);


--
-- TOC entry 7539 (class 0 OID 0)
-- Dependencies: 363
-- Name: plaza_toros_a_gid_seq; Type: SEQUENCE SET; Schema: gs_recreacion; Owner: postgres
--

SELECT pg_catalog.setval('gs_recreacion.plaza_toros_a_gid_seq', 1, false);


--
-- TOC entry 7540 (class 0 OID 0)
-- Dependencies: 365
-- Name: acequia_l_gid_seq; Type: SEQUENCE SET; Schema: ho_aguas_interiores; Owner: postgres
--

SELECT pg_catalog.setval('ho_aguas_interiores.acequia_l_gid_seq', 1, false);


--
-- TOC entry 7541 (class 0 OID 0)
-- Dependencies: 367
-- Name: acueducto_canal_a_gid_seq; Type: SEQUENCE SET; Schema: ho_aguas_interiores; Owner: postgres
--

SELECT pg_catalog.setval('ho_aguas_interiores.acueducto_canal_a_gid_seq', 1, false);


--
-- TOC entry 7542 (class 0 OID 0)
-- Dependencies: 369
-- Name: lago_laguna_a_gid_seq; Type: SEQUENCE SET; Schema: ho_aguas_interiores; Owner: postgres
--

SELECT pg_catalog.setval('ho_aguas_interiores.lago_laguna_a_gid_seq', 1, false);


--
-- TOC entry 7543 (class 0 OID 0)
-- Dependencies: 371
-- Name: rio_a_gid_seq; Type: SEQUENCE SET; Schema: ho_aguas_interiores; Owner: postgres
--

SELECT pg_catalog.setval('ho_aguas_interiores.rio_a_gid_seq', 1, false);


--
-- TOC entry 7544 (class 0 OID 0)
-- Dependencies: 373
-- Name: rio_l_gid_seq; Type: SEQUENCE SET; Schema: ho_aguas_interiores; Owner: postgres
--

SELECT pg_catalog.setval('ho_aguas_interiores.rio_l_gid_seq', 1, false);


--
-- TOC entry 7545 (class 0 OID 0)
-- Dependencies: 375
-- Name: zanja_l_gid_seq; Type: SEQUENCE SET; Schema: ho_aguas_interiores; Owner: postgres
--

SELECT pg_catalog.setval('ho_aguas_interiores.zanja_l_gid_seq', 1, false);


--
-- TOC entry 7546 (class 0 OID 0)
-- Dependencies: 377
-- Name: puerto_a_gid_seq; Type: SEQUENCE SET; Schema: ho_puertos_muelles; Owner: postgres
--

SELECT pg_catalog.setval('ho_puertos_muelles.puerto_a_gid_seq', 1, false);


--
-- TOC entry 7547 (class 0 OID 0)
-- Dependencies: 379
-- Name: granja_acuatica_a_gid_seq; Type: SEQUENCE SET; Schema: ho_regulacion_zonas_restringidas; Owner: postgres
--

SELECT pg_catalog.setval('ho_regulacion_zonas_restringidas.granja_acuatica_a_gid_seq', 1, false);


--
-- TOC entry 7548 (class 0 OID 0)
-- Dependencies: 381
-- Name: isla_a_gid_seq; Type: SEQUENCE SET; Schema: ho_zonas_costeras; Owner: postgres
--

SELECT pg_catalog.setval('ho_zonas_costeras.isla_a_gid_seq', 1, false);


--
-- TOC entry 7549 (class 0 OID 0)
-- Dependencies: 383
-- Name: orilla_l_gid_seq; Type: SEQUENCE SET; Schema: ho_zonas_costeras; Owner: postgres
--

SELECT pg_catalog.setval('ho_zonas_costeras.orilla_l_gid_seq', 1, false);


--
-- TOC entry 7550 (class 0 OID 0)
-- Dependencies: 385
-- Name: invernadero_a_gid_seq; Type: SEQUENCE SET; Schema: ii_agropecuaria; Owner: postgres
--

SELECT pg_catalog.setval('ii_agropecuaria.invernadero_a_gid_seq', 1, false);


--
-- TOC entry 7551 (class 0 OID 0)
-- Dependencies: 387
-- Name: acera_a_gid_seq; Type: SEQUENCE SET; Schema: it_asociado_transportacion; Owner: postgres
--

SELECT pg_catalog.setval('it_asociado_transportacion.acera_a_gid_seq', 1, false);


--
-- TOC entry 7552 (class 0 OID 0)
-- Dependencies: 389
-- Name: bordillo_l_gid_seq; Type: SEQUENCE SET; Schema: it_asociado_transportacion; Owner: postgres
--

SELECT pg_catalog.setval('it_asociado_transportacion.bordillo_l_gid_seq', 1, false);


--
-- TOC entry 7553 (class 0 OID 0)
-- Dependencies: 391
-- Name: cuneta_a_gid_seq; Type: SEQUENCE SET; Schema: it_asociado_transportacion; Owner: postgres
--

SELECT pg_catalog.setval('it_asociado_transportacion.cuneta_a_gid_seq', 1, false);


--
-- TOC entry 7554 (class 0 OID 0)
-- Dependencies: 393
-- Name: parqueadero_a_gid_seq; Type: SEQUENCE SET; Schema: it_asociado_transportacion; Owner: postgres
--

SELECT pg_catalog.setval('it_asociado_transportacion.parqueadero_a_gid_seq', 1, false);


--
-- TOC entry 7555 (class 0 OID 0)
-- Dependencies: 395
-- Name: paseo_peatonal_ciclovia_a_gid_seq; Type: SEQUENCE SET; Schema: it_asociado_transportacion; Owner: postgres
--

SELECT pg_catalog.setval('it_asociado_transportacion.paseo_peatonal_ciclovia_a_gid_seq', 1, false);


--
-- TOC entry 7556 (class 0 OID 0)
-- Dependencies: 397
-- Name: tunel_a_gid_seq; Type: SEQUENCE SET; Schema: it_asociado_transportacion; Owner: postgres
--

SELECT pg_catalog.setval('it_asociado_transportacion.tunel_a_gid_seq', 1, false);


--
-- TOC entry 7557 (class 0 OID 0)
-- Dependencies: 399
-- Name: puente_a_gid_seq; Type: SEQUENCE SET; Schema: it_cruces_enlaces; Owner: postgres
--

SELECT pg_catalog.setval('it_cruces_enlaces.puente_a_gid_seq', 1, false);


--
-- TOC entry 7558 (class 0 OID 0)
-- Dependencies: 401
-- Name: ferrocarril_a_gid_seq; Type: SEQUENCE SET; Schema: it_ferrocarriles; Owner: postgres
--

SELECT pg_catalog.setval('it_ferrocarriles.ferrocarril_a_gid_seq', 1, false);


--
-- TOC entry 7559 (class 0 OID 0)
-- Dependencies: 403
-- Name: gasolinera_a_gid_seq; Type: SEQUENCE SET; Schema: it_transporte_terrestre; Owner: postgres
--

SELECT pg_catalog.setval('it_transporte_terrestre.gasolinera_a_gid_seq', 1, false);


--
-- TOC entry 7560 (class 0 OID 0)
-- Dependencies: 405
-- Name: intercambiador_vial_a_gid_seq; Type: SEQUENCE SET; Schema: it_transporte_terrestre; Owner: postgres
--

SELECT pg_catalog.setval('it_transporte_terrestre.intercambiador_vial_a_gid_seq', 1, false);


--
-- TOC entry 7561 (class 0 OID 0)
-- Dependencies: 407
-- Name: rodera_l_gid_seq; Type: SEQUENCE SET; Schema: it_transporte_terrestre; Owner: postgres
--

SELECT pg_catalog.setval('it_transporte_terrestre.rodera_l_gid_seq', 14157, true);


--
-- TOC entry 7562 (class 0 OID 0)
-- Dependencies: 409
-- Name: sendero_l_gid_seq; Type: SEQUENCE SET; Schema: it_transporte_terrestre; Owner: postgres
--

SELECT pg_catalog.setval('it_transporte_terrestre.sendero_l_gid_seq', 1, false);


--
-- TOC entry 7563 (class 0 OID 0)
-- Dependencies: 411
-- Name: via_ruta_a_gid_seq; Type: SEQUENCE SET; Schema: it_transporte_terrestre; Owner: postgres
--

SELECT pg_catalog.setval('it_transporte_terrestre.via_ruta_a_gid_seq', 105, true);


--
-- TOC entry 6846 (class 2606 OID 2453145)
-- Name: aeropuerto_a aeropuerto_a_pkey; Type: CONSTRAINT; Schema: a_aeropuerto_superficie; Owner: postgres
--

ALTER TABLE ONLY a_aeropuerto_superficie.aeropuerto_a
    ADD CONSTRAINT aeropuerto_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6849 (class 2606 OID 2453147)
-- Name: acc acc_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.acc
    ADD CONSTRAINT acc_pkey PRIMARY KEY (acc);


--
-- TOC entry 6851 (class 2606 OID 2453149)
-- Name: atc atc_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.atc
    ADD CONSTRAINT atc_pkey PRIMARY KEY (atc);


--
-- TOC entry 6853 (class 2606 OID 2453151)
-- Name: bsc bsc_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.bsc
    ADD CONSTRAINT bsc_pkey PRIMARY KEY (bsc);


--
-- TOC entry 6855 (class 2606 OID 2453153)
-- Name: catalogo_objetos catalogo_objetos_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.catalogo_objetos
    ADD CONSTRAINT catalogo_objetos_pkey PRIMARY KEY (fcode);


--
-- TOC entry 6857 (class 2606 OID 2453155)
-- Name: dit dit_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.dit
    ADD CONSTRAINT dit_pkey PRIMARY KEY (dit);


--
-- TOC entry 6859 (class 2606 OID 2453157)
-- Name: ela ela_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.ela
    ADD CONSTRAINT ela_pkey PRIMARY KEY (ela);


--
-- TOC entry 6861 (class 2606 OID 2453159)
-- Name: fco fco_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.fco
    ADD CONSTRAINT fco_pkey PRIMARY KEY (fco);


--
-- TOC entry 6863 (class 2606 OID 2453161)
-- Name: fti fti_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.fti
    ADD CONSTRAINT fti_pkey PRIMARY KEY (fti);


--
-- TOC entry 6865 (class 2606 OID 2453163)
-- Name: fuc fuc_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.fuc
    ADD CONSTRAINT fuc_pkey PRIMARY KEY (fuc);


--
-- TOC entry 6867 (class 2606 OID 2453165)
-- Name: hct hct_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.hct
    ADD CONSTRAINT hct_pkey PRIMARY KEY (hct);


--
-- TOC entry 6869 (class 2606 OID 2453167)
-- Name: hyp hyp_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.hyp
    ADD CONSTRAINT hyp_pkey PRIMARY KEY (hyp);


--
-- TOC entry 6871 (class 2606 OID 2453169)
-- Name: kos kos_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.kos
    ADD CONSTRAINT kos_pkey PRIMARY KEY (kos);


--
-- TOC entry 6873 (class 2606 OID 2453171)
-- Name: loc loc_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.loc
    ADD CONSTRAINT loc_pkey PRIMARY KEY (loc);


--
-- TOC entry 6875 (class 2606 OID 2453173)
-- Name: mes mes_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.mes
    ADD CONSTRAINT mes_pkey PRIMARY KEY (mes);


--
-- TOC entry 6877 (class 2606 OID 2453175)
-- Name: rdt rdt_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.rdt
    ADD CONSTRAINT rdt_pkey PRIMARY KEY (rdt);


--
-- TOC entry 6879 (class 2606 OID 2453177)
-- Name: rel rel_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.rel
    ADD CONSTRAINT rel_pkey PRIMARY KEY (rel);


--
-- TOC entry 6881 (class 2606 OID 2453179)
-- Name: rgc rgc_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.rgc
    ADD CONSTRAINT rgc_pkey PRIMARY KEY (rgc);


--
-- TOC entry 6883 (class 2606 OID 2453181)
-- Name: rra rra_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.rra
    ADD CONSTRAINT rra_pkey PRIMARY KEY (rra);


--
-- TOC entry 6885 (class 2606 OID 2453183)
-- Name: rrc rrc_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.rrc
    ADD CONSTRAINT rrc_pkey PRIMARY KEY (rrc);


--
-- TOC entry 6887 (class 2606 OID 2453185)
-- Name: rst rst_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.rst
    ADD CONSTRAINT rst_pkey PRIMARY KEY (rst);


--
-- TOC entry 6889 (class 2606 OID 2453187)
-- Name: slt slt_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.slt
    ADD CONSTRAINT slt_pkey PRIMARY KEY (slt);


--
-- TOC entry 6891 (class 2606 OID 2453189)
-- Name: smc smc_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.smc
    ADD CONSTRAINT smc_pkey PRIMARY KEY (smc);


--
-- TOC entry 6893 (class 2606 OID 2453191)
-- Name: tra tra_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.tra
    ADD CONSTRAINT tra_pkey PRIMARY KEY (tra);


--
-- TOC entry 6895 (class 2606 OID 2453193)
-- Name: tuc tuc_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.tuc
    ADD CONSTRAINT tuc_pkey PRIMARY KEY (tuc);


--
-- TOC entry 6897 (class 2606 OID 2453195)
-- Name: typ typ_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.typ
    ADD CONSTRAINT typ_pkey PRIMARY KEY (typ);


--
-- TOC entry 6899 (class 2606 OID 2453197)
-- Name: uuc uuc_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.uuc
    ADD CONSTRAINT uuc_pkey PRIMARY KEY (uuc);


--
-- TOC entry 6901 (class 2606 OID 2453199)
-- Name: wtc wtc_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.wtc
    ADD CONSTRAINT wtc_pkey PRIMARY KEY (wtc);


--
-- TOC entry 6903 (class 2606 OID 2453201)
-- Name: wti wti_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.wti
    ADD CONSTRAINT wti_pkey PRIMARY KEY (wti);


--
-- TOC entry 6905 (class 2606 OID 2453203)
-- Name: punto_control_p punto_control_p_pkey; Type: CONSTRAINT; Schema: d_linderos_propiedad; Owner: postgres
--

ALTER TABLE ONLY d_linderos_propiedad.punto_control_p
    ADD CONSTRAINT punto_control_p_pkey PRIMARY KEY (gid);


--
-- TOC entry 6908 (class 2606 OID 2453205)
-- Name: cementerio_a cementerio_a_pkey; Type: CONSTRAINT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.cementerio_a
    ADD CONSTRAINT cementerio_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6911 (class 2606 OID 2453207)
-- Name: cerca_l cerca_l_pkey; Type: CONSTRAINT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.cerca_l
    ADD CONSTRAINT cerca_l_pkey PRIMARY KEY (gid);


--
-- TOC entry 6914 (class 2606 OID 2453209)
-- Name: escalinata_a escalinata_a_pkey; Type: CONSTRAINT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.escalinata_a
    ADD CONSTRAINT escalinata_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6917 (class 2606 OID 2453211)
-- Name: muro_l muro_l_pkey; Type: CONSTRAINT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.muro_l
    ADD CONSTRAINT muro_l_pkey PRIMARY KEY (gid);


--
-- TOC entry 6920 (class 2606 OID 2453213)
-- Name: plaza_publica_a plaza_publica_a_pkey; Type: CONSTRAINT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.plaza_publica_a
    ADD CONSTRAINT plaza_publica_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6923 (class 2606 OID 2453215)
-- Name: edificio_a edificio_a_pkey; Type: CONSTRAINT; Schema: gs_construcciones; Owner: postgres
--

ALTER TABLE ONLY gs_construcciones.edificio_a
    ADD CONSTRAINT edificio_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6926 (class 2606 OID 2453217)
-- Name: cancha_a cancha_a_pkey; Type: CONSTRAINT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.cancha_a
    ADD CONSTRAINT cancha_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6929 (class 2606 OID 2453219)
-- Name: estadio_a estadio_a_pkey; Type: CONSTRAINT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.estadio_a
    ADD CONSTRAINT estadio_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6932 (class 2606 OID 2453221)
-- Name: parque_a parque_a_pkey; Type: CONSTRAINT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.parque_a
    ADD CONSTRAINT parque_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6935 (class 2606 OID 2453223)
-- Name: piscina_a piscina_a_pkey; Type: CONSTRAINT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.piscina_a
    ADD CONSTRAINT piscina_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6938 (class 2606 OID 2453225)
-- Name: plaza_toros_a plaza_toros_a_pkey; Type: CONSTRAINT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.plaza_toros_a
    ADD CONSTRAINT plaza_toros_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6941 (class 2606 OID 2453227)
-- Name: acequia_l acequia_l_pkey; Type: CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.acequia_l
    ADD CONSTRAINT acequia_l_pkey PRIMARY KEY (gid);


--
-- TOC entry 6944 (class 2606 OID 2453229)
-- Name: acueducto_canal_a acueducto_a_pkey; Type: CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.acueducto_canal_a
    ADD CONSTRAINT acueducto_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6947 (class 2606 OID 2453231)
-- Name: lago_laguna_a lago_laguna_a_pkey; Type: CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.lago_laguna_a
    ADD CONSTRAINT lago_laguna_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6950 (class 2606 OID 2453233)
-- Name: rio_a rio_a_pkey; Type: CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.rio_a
    ADD CONSTRAINT rio_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6953 (class 2606 OID 2453235)
-- Name: rio_l rio_l_pkey; Type: CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.rio_l
    ADD CONSTRAINT rio_l_pkey PRIMARY KEY (gid);


--
-- TOC entry 6957 (class 2606 OID 2453237)
-- Name: zanja_l zanja_l_pkey; Type: CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.zanja_l
    ADD CONSTRAINT zanja_l_pkey PRIMARY KEY (gid);


--
-- TOC entry 6959 (class 2606 OID 2453239)
-- Name: puerto_a puerto_a_pkey; Type: CONSTRAINT; Schema: ho_puertos_muelles; Owner: postgres
--

ALTER TABLE ONLY ho_puertos_muelles.puerto_a
    ADD CONSTRAINT puerto_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6962 (class 2606 OID 2453241)
-- Name: granja_acuatica_a granja_acuatica_a_pkey; Type: CONSTRAINT; Schema: ho_regulacion_zonas_restringidas; Owner: postgres
--

ALTER TABLE ONLY ho_regulacion_zonas_restringidas.granja_acuatica_a
    ADD CONSTRAINT granja_acuatica_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6965 (class 2606 OID 2453243)
-- Name: isla_a isla_a_pkey; Type: CONSTRAINT; Schema: ho_zonas_costeras; Owner: postgres
--

ALTER TABLE ONLY ho_zonas_costeras.isla_a
    ADD CONSTRAINT isla_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6968 (class 2606 OID 2453245)
-- Name: orilla_l orilla_l_pkey; Type: CONSTRAINT; Schema: ho_zonas_costeras; Owner: postgres
--

ALTER TABLE ONLY ho_zonas_costeras.orilla_l
    ADD CONSTRAINT orilla_l_pkey PRIMARY KEY (gid);


--
-- TOC entry 6971 (class 2606 OID 2453247)
-- Name: invernadero_a hacienda_a_pkey; Type: CONSTRAINT; Schema: ii_agropecuaria; Owner: postgres
--

ALTER TABLE ONLY ii_agropecuaria.invernadero_a
    ADD CONSTRAINT hacienda_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6974 (class 2606 OID 2453249)
-- Name: acera_a acera_a_pkey; Type: CONSTRAINT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.acera_a
    ADD CONSTRAINT acera_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6977 (class 2606 OID 2453251)
-- Name: bordillo_l bordillo_l_pkey; Type: CONSTRAINT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.bordillo_l
    ADD CONSTRAINT bordillo_l_pkey PRIMARY KEY (gid);


--
-- TOC entry 6980 (class 2606 OID 2453253)
-- Name: cuneta_a cuneta_a_pkey; Type: CONSTRAINT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.cuneta_a
    ADD CONSTRAINT cuneta_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6983 (class 2606 OID 2453255)
-- Name: parqueadero_a parqueadero_a_pkey; Type: CONSTRAINT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.parqueadero_a
    ADD CONSTRAINT parqueadero_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6986 (class 2606 OID 2453257)
-- Name: paseo_peatonal_ciclovia_a paseo_peatonal_ciclovia_a_pkey; Type: CONSTRAINT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.paseo_peatonal_ciclovia_a
    ADD CONSTRAINT paseo_peatonal_ciclovia_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6989 (class 2606 OID 2453259)
-- Name: tunel_a tunel_a_pkey; Type: CONSTRAINT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.tunel_a
    ADD CONSTRAINT tunel_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6992 (class 2606 OID 2453261)
-- Name: puente_a puente_a_pkey; Type: CONSTRAINT; Schema: it_cruces_enlaces; Owner: postgres
--

ALTER TABLE ONLY it_cruces_enlaces.puente_a
    ADD CONSTRAINT puente_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6995 (class 2606 OID 2453263)
-- Name: ferrocarril_a ferrocarril_a_pkey; Type: CONSTRAINT; Schema: it_ferrocarriles; Owner: postgres
--

ALTER TABLE ONLY it_ferrocarriles.ferrocarril_a
    ADD CONSTRAINT ferrocarril_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6998 (class 2606 OID 2453265)
-- Name: gasolinera_a gasolinera_a_pkey; Type: CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.gasolinera_a
    ADD CONSTRAINT gasolinera_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 7001 (class 2606 OID 2453267)
-- Name: intercambiador_vial_a intercambiador_vial_a_pkey; Type: CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.intercambiador_vial_a
    ADD CONSTRAINT intercambiador_vial_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 7004 (class 2606 OID 2453269)
-- Name: rodera_l rodera_l_pkey; Type: CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.rodera_l
    ADD CONSTRAINT rodera_l_pkey PRIMARY KEY (gid);


--
-- TOC entry 7007 (class 2606 OID 2453271)
-- Name: sendero_l sendero_l_pkey; Type: CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.sendero_l
    ADD CONSTRAINT sendero_l_pkey PRIMARY KEY (gid);


--
-- TOC entry 7011 (class 2606 OID 2453273)
-- Name: via_ruta_a via_ruta_a_pkey; Type: CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.via_ruta_a
    ADD CONSTRAINT via_ruta_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 7013 (class 2606 OID 2453275)
-- Name: qgis_projects qgis_projects_pkey; Type: CONSTRAINT; Schema: proyecto_qgis3; Owner: postgres
--

ALTER TABLE ONLY proyecto_qgis3.qgis_projects
    ADD CONSTRAINT qgis_projects_pkey PRIMARY KEY (name);


--
-- TOC entry 6847 (class 1259 OID 2453276)
-- Name: sidx_aeropuerto_a; Type: INDEX; Schema: a_aeropuerto_superficie; Owner: postgres
--

CREATE INDEX sidx_aeropuerto_a ON a_aeropuerto_superficie.aeropuerto_a USING gist (the_geom);

ALTER TABLE a_aeropuerto_superficie.aeropuerto_a CLUSTER ON sidx_aeropuerto_a;


--
-- TOC entry 6906 (class 1259 OID 2453277)
-- Name: sidx_punto_control_p; Type: INDEX; Schema: d_linderos_propiedad; Owner: postgres
--

CREATE INDEX sidx_punto_control_p ON d_linderos_propiedad.punto_control_p USING gist (the_geom);


--
-- TOC entry 6909 (class 1259 OID 2453278)
-- Name: sidx_cementerio_a; Type: INDEX; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE INDEX sidx_cementerio_a ON gs_asociado_poblados.cementerio_a USING gist (the_geom);


--
-- TOC entry 6912 (class 1259 OID 2453279)
-- Name: sidx_cerca_l; Type: INDEX; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE INDEX sidx_cerca_l ON gs_asociado_poblados.cerca_l USING gist (the_geom);


--
-- TOC entry 6915 (class 1259 OID 2453280)
-- Name: sidx_escalinata_a; Type: INDEX; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE INDEX sidx_escalinata_a ON gs_asociado_poblados.escalinata_a USING gist (the_geom);


--
-- TOC entry 6918 (class 1259 OID 2453281)
-- Name: sidx_muro_l; Type: INDEX; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE INDEX sidx_muro_l ON gs_asociado_poblados.muro_l USING gist (the_geom);


--
-- TOC entry 6921 (class 1259 OID 2453282)
-- Name: sidx_plaza_publica_a; Type: INDEX; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE INDEX sidx_plaza_publica_a ON gs_asociado_poblados.plaza_publica_a USING gist (the_geom);


--
-- TOC entry 6924 (class 1259 OID 2453283)
-- Name: sidx_edificio_a; Type: INDEX; Schema: gs_construcciones; Owner: postgres
--

CREATE INDEX sidx_edificio_a ON gs_construcciones.edificio_a USING gist (the_geom);

ALTER TABLE gs_construcciones.edificio_a CLUSTER ON sidx_edificio_a;


--
-- TOC entry 6927 (class 1259 OID 2453284)
-- Name: sidx_cancha_a; Type: INDEX; Schema: gs_recreacion; Owner: postgres
--

CREATE INDEX sidx_cancha_a ON gs_recreacion.cancha_a USING gist (the_geom);


--
-- TOC entry 6930 (class 1259 OID 2453285)
-- Name: sidx_estadio_a; Type: INDEX; Schema: gs_recreacion; Owner: postgres
--

CREATE INDEX sidx_estadio_a ON gs_recreacion.estadio_a USING gist (the_geom);


--
-- TOC entry 6933 (class 1259 OID 2453286)
-- Name: sidx_parque_a; Type: INDEX; Schema: gs_recreacion; Owner: postgres
--

CREATE INDEX sidx_parque_a ON gs_recreacion.parque_a USING gist (the_geom);


--
-- TOC entry 6936 (class 1259 OID 2453287)
-- Name: sidx_piscina_a; Type: INDEX; Schema: gs_recreacion; Owner: postgres
--

CREATE INDEX sidx_piscina_a ON gs_recreacion.piscina_a USING gist (the_geom);


--
-- TOC entry 6939 (class 1259 OID 2453288)
-- Name: sidx_plaza_toros_a; Type: INDEX; Schema: gs_recreacion; Owner: postgres
--

CREATE INDEX sidx_plaza_toros_a ON gs_recreacion.plaza_toros_a USING gist (the_geom);


--
-- TOC entry 6942 (class 1259 OID 2453289)
-- Name: sidx_acequia_l; Type: INDEX; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE INDEX sidx_acequia_l ON ho_aguas_interiores.acequia_l USING gist (the_geom);


--
-- TOC entry 6945 (class 1259 OID 2453290)
-- Name: sidx_acueducto_a; Type: INDEX; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE INDEX sidx_acueducto_a ON ho_aguas_interiores.acueducto_canal_a USING gist (the_geom);


--
-- TOC entry 6948 (class 1259 OID 2453291)
-- Name: sidx_lago_laguna_a; Type: INDEX; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE INDEX sidx_lago_laguna_a ON ho_aguas_interiores.lago_laguna_a USING gist (the_geom);


--
-- TOC entry 6951 (class 1259 OID 2453292)
-- Name: sidx_rio_a; Type: INDEX; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE INDEX sidx_rio_a ON ho_aguas_interiores.rio_a USING gist (the_geom);


--
-- TOC entry 6954 (class 1259 OID 2453293)
-- Name: sidx_rio_l; Type: INDEX; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE INDEX sidx_rio_l ON ho_aguas_interiores.rio_l USING gist (the_geom);

ALTER TABLE ho_aguas_interiores.rio_l CLUSTER ON sidx_rio_l;


--
-- TOC entry 6955 (class 1259 OID 2453294)
-- Name: sidx_zanja_l; Type: INDEX; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE INDEX sidx_zanja_l ON ho_aguas_interiores.zanja_l USING gist (the_geom);


--
-- TOC entry 6960 (class 1259 OID 2453295)
-- Name: sidx_puerto_a; Type: INDEX; Schema: ho_puertos_muelles; Owner: postgres
--

CREATE INDEX sidx_puerto_a ON ho_puertos_muelles.puerto_a USING gist (the_geom);


--
-- TOC entry 6963 (class 1259 OID 2453296)
-- Name: sidx_granja_acuatica_a; Type: INDEX; Schema: ho_regulacion_zonas_restringidas; Owner: postgres
--

CREATE INDEX sidx_granja_acuatica_a ON ho_regulacion_zonas_restringidas.granja_acuatica_a USING gist (the_geom);


--
-- TOC entry 6966 (class 1259 OID 2453297)
-- Name: sidx_isla_a; Type: INDEX; Schema: ho_zonas_costeras; Owner: postgres
--

CREATE INDEX sidx_isla_a ON ho_zonas_costeras.isla_a USING gist (the_geom);


--
-- TOC entry 6969 (class 1259 OID 2453298)
-- Name: sidx_orilla_l; Type: INDEX; Schema: ho_zonas_costeras; Owner: postgres
--

CREATE INDEX sidx_orilla_l ON ho_zonas_costeras.orilla_l USING gist (the_geom);


--
-- TOC entry 6972 (class 1259 OID 2453299)
-- Name: sidx_hacienda_a; Type: INDEX; Schema: ii_agropecuaria; Owner: postgres
--

CREATE INDEX sidx_hacienda_a ON ii_agropecuaria.invernadero_a USING gist (the_geom);


--
-- TOC entry 6975 (class 1259 OID 2453300)
-- Name: acera_a_sidx_paseo_peatonal_ciclovia_a; Type: INDEX; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE INDEX acera_a_sidx_paseo_peatonal_ciclovia_a ON it_asociado_transportacion.acera_a USING gist (the_geom);


--
-- TOC entry 6978 (class 1259 OID 2453301)
-- Name: bordillo_l_sidx_bordillo_l; Type: INDEX; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE INDEX bordillo_l_sidx_bordillo_l ON it_asociado_transportacion.bordillo_l USING gist (the_geom);


--
-- TOC entry 6981 (class 1259 OID 2453302)
-- Name: cuneta_a_sidx_cuneta_a; Type: INDEX; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE INDEX cuneta_a_sidx_cuneta_a ON it_asociado_transportacion.cuneta_a USING gist (the_geom);


--
-- TOC entry 6984 (class 1259 OID 2453303)
-- Name: sidx_parqueadero_a; Type: INDEX; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE INDEX sidx_parqueadero_a ON it_asociado_transportacion.parqueadero_a USING gist (the_geom);


--
-- TOC entry 6987 (class 1259 OID 2453304)
-- Name: sidx_paseo_peatonal_ciclovia_a; Type: INDEX; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE INDEX sidx_paseo_peatonal_ciclovia_a ON it_asociado_transportacion.paseo_peatonal_ciclovia_a USING gist (the_geom);


--
-- TOC entry 6990 (class 1259 OID 2453305)
-- Name: tunel_a_sidx_tunel_a; Type: INDEX; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE INDEX tunel_a_sidx_tunel_a ON it_asociado_transportacion.tunel_a USING gist (the_geom);


--
-- TOC entry 6993 (class 1259 OID 2453306)
-- Name: sidx_puente_a; Type: INDEX; Schema: it_cruces_enlaces; Owner: postgres
--

CREATE INDEX sidx_puente_a ON it_cruces_enlaces.puente_a USING gist (the_geom);


--
-- TOC entry 6996 (class 1259 OID 2453307)
-- Name: ferrocarril_a_sidx_ferrocarril_a; Type: INDEX; Schema: it_ferrocarriles; Owner: postgres
--

CREATE INDEX ferrocarril_a_sidx_ferrocarril_a ON it_ferrocarriles.ferrocarril_a USING gist (the_geom);


--
-- TOC entry 6999 (class 1259 OID 2453308)
-- Name: sidx_gasolinera_a; Type: INDEX; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE INDEX sidx_gasolinera_a ON it_transporte_terrestre.gasolinera_a USING gist (the_geom);


--
-- TOC entry 7002 (class 1259 OID 2453309)
-- Name: sidx_intercambiador_vial_a; Type: INDEX; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE INDEX sidx_intercambiador_vial_a ON it_transporte_terrestre.intercambiador_vial_a USING gist (the_geom);


--
-- TOC entry 7005 (class 1259 OID 2453310)
-- Name: sidx_rodera_l; Type: INDEX; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE INDEX sidx_rodera_l ON it_transporte_terrestre.rodera_l USING gist (the_geom);


--
-- TOC entry 7008 (class 1259 OID 2453311)
-- Name: sidx_sendero_l; Type: INDEX; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE INDEX sidx_sendero_l ON it_transporte_terrestre.sendero_l USING gist (the_geom);


--
-- TOC entry 7009 (class 1259 OID 2453312)
-- Name: sidx_via_ruta_a; Type: INDEX; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE INDEX sidx_via_ruta_a ON it_transporte_terrestre.via_ruta_a USING gist (the_geom);


--
-- TOC entry 7297 (class 2618 OID 2453313)
-- Name: aeropuerto_a omitir_duplicados; Type: RULE; Schema: a_aeropuerto_superficie; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO a_aeropuerto_superficie.aeropuerto_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM a_aeropuerto_superficie.aeropuerto_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7298 (class 2618 OID 2453315)
-- Name: punto_control_p omitir_duplicados; Type: RULE; Schema: d_linderos_propiedad; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO d_linderos_propiedad.punto_control_p
   WHERE (0 <> ( SELECT count(*) AS count
           FROM d_linderos_propiedad.punto_control_p a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7299 (class 2618 OID 2453317)
-- Name: plaza_publica_a omitir_duplicados; Type: RULE; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO gs_asociado_poblados.plaza_publica_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM gs_asociado_poblados.plaza_publica_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7300 (class 2618 OID 2453319)
-- Name: muro_l omitir_duplicados; Type: RULE; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO gs_asociado_poblados.muro_l
   WHERE (0 <> ( SELECT count(*) AS count
           FROM gs_asociado_poblados.muro_l a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7301 (class 2618 OID 2453321)
-- Name: escalinata_a omitir_duplicados; Type: RULE; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO gs_asociado_poblados.escalinata_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM gs_asociado_poblados.escalinata_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7302 (class 2618 OID 2453323)
-- Name: cerca_l omitir_duplicados; Type: RULE; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO gs_asociado_poblados.cerca_l
   WHERE (0 <> ( SELECT count(*) AS count
           FROM gs_asociado_poblados.cerca_l a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7303 (class 2618 OID 2453325)
-- Name: cementerio_a omitir_duplicados; Type: RULE; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO gs_asociado_poblados.cementerio_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM gs_asociado_poblados.cementerio_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7304 (class 2618 OID 2453327)
-- Name: edificio_a omitir_duplicados; Type: RULE; Schema: gs_construcciones; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO gs_construcciones.edificio_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM gs_construcciones.edificio_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7305 (class 2618 OID 2453329)
-- Name: plaza_toros_a omitir_duplicados; Type: RULE; Schema: gs_recreacion; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO gs_recreacion.plaza_toros_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM gs_recreacion.plaza_toros_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7306 (class 2618 OID 2453331)
-- Name: piscina_a omitir_duplicados; Type: RULE; Schema: gs_recreacion; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO gs_recreacion.piscina_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM gs_recreacion.piscina_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7307 (class 2618 OID 2453333)
-- Name: parque_a omitir_duplicados; Type: RULE; Schema: gs_recreacion; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO gs_recreacion.parque_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM gs_recreacion.parque_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7308 (class 2618 OID 2453335)
-- Name: estadio_a omitir_duplicados; Type: RULE; Schema: gs_recreacion; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO gs_recreacion.estadio_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM gs_recreacion.estadio_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7309 (class 2618 OID 2453337)
-- Name: cancha_a omitir_duplicados; Type: RULE; Schema: gs_recreacion; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO gs_recreacion.cancha_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM gs_recreacion.cancha_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7310 (class 2618 OID 2453339)
-- Name: zanja_l omitir_duplicados; Type: RULE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO ho_aguas_interiores.zanja_l
   WHERE (0 <> ( SELECT count(*) AS count
           FROM ho_aguas_interiores.zanja_l a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7311 (class 2618 OID 2453341)
-- Name: rio_l omitir_duplicados; Type: RULE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO ho_aguas_interiores.rio_l
   WHERE (0 <> ( SELECT count(*) AS count
           FROM ho_aguas_interiores.rio_l a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7312 (class 2618 OID 2453343)
-- Name: rio_a omitir_duplicados; Type: RULE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO ho_aguas_interiores.rio_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM ho_aguas_interiores.rio_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7313 (class 2618 OID 2453345)
-- Name: lago_laguna_a omitir_duplicados; Type: RULE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO ho_aguas_interiores.lago_laguna_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM ho_aguas_interiores.lago_laguna_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7314 (class 2618 OID 2453347)
-- Name: acueducto_canal_a omitir_duplicados; Type: RULE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO ho_aguas_interiores.acueducto_canal_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM ho_aguas_interiores.acueducto_canal_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7315 (class 2618 OID 2453349)
-- Name: acequia_l omitir_duplicados; Type: RULE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO ho_aguas_interiores.acequia_l
   WHERE (0 <> ( SELECT count(*) AS count
           FROM ho_aguas_interiores.acequia_l a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7316 (class 2618 OID 2453351)
-- Name: puerto_a omitir_duplicados; Type: RULE; Schema: ho_puertos_muelles; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO ho_puertos_muelles.puerto_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM ho_puertos_muelles.puerto_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7317 (class 2618 OID 2453353)
-- Name: granja_acuatica_a omitir_duplicados; Type: RULE; Schema: ho_regulacion_zonas_restringidas; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO ho_regulacion_zonas_restringidas.granja_acuatica_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM ho_regulacion_zonas_restringidas.granja_acuatica_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7318 (class 2618 OID 2453355)
-- Name: orilla_l omitir_duplicados; Type: RULE; Schema: ho_zonas_costeras; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO ho_zonas_costeras.orilla_l
   WHERE (0 <> ( SELECT count(*) AS count
           FROM ho_zonas_costeras.orilla_l a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7319 (class 2618 OID 2453357)
-- Name: isla_a omitir_duplicados; Type: RULE; Schema: ho_zonas_costeras; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO ho_zonas_costeras.isla_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM ho_zonas_costeras.isla_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7320 (class 2618 OID 2453359)
-- Name: invernadero_a omitir_duplicados; Type: RULE; Schema: ii_agropecuaria; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO ii_agropecuaria.invernadero_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM ii_agropecuaria.invernadero_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7321 (class 2618 OID 2453361)
-- Name: paseo_peatonal_ciclovia_a omitir_duplicados; Type: RULE; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO it_asociado_transportacion.paseo_peatonal_ciclovia_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM it_asociado_transportacion.paseo_peatonal_ciclovia_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7322 (class 2618 OID 2453363)
-- Name: parqueadero_a omitir_duplicados; Type: RULE; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO it_asociado_transportacion.parqueadero_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM it_asociado_transportacion.parqueadero_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7323 (class 2618 OID 2453365)
-- Name: bordillo_l omitir_duplicados; Type: RULE; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO it_asociado_transportacion.bordillo_l
   WHERE (0 <> ( SELECT count(*) AS count
           FROM it_asociado_transportacion.bordillo_l a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7324 (class 2618 OID 2453367)
-- Name: acera_a omitir_duplicados; Type: RULE; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO it_asociado_transportacion.acera_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM it_asociado_transportacion.paseo_peatonal_ciclovia_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7325 (class 2618 OID 2453369)
-- Name: tunel_a omitir_duplicados; Type: RULE; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO it_asociado_transportacion.tunel_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM it_asociado_transportacion.tunel_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7326 (class 2618 OID 2453371)
-- Name: cuneta_a omitir_duplicados; Type: RULE; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO it_asociado_transportacion.cuneta_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM it_asociado_transportacion.cuneta_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7327 (class 2618 OID 2453373)
-- Name: puente_a omitir_duplicados; Type: RULE; Schema: it_cruces_enlaces; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO it_cruces_enlaces.puente_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM it_cruces_enlaces.puente_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7328 (class 2618 OID 2453375)
-- Name: ferrocarril_a omitir_duplicados; Type: RULE; Schema: it_ferrocarriles; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO it_ferrocarriles.ferrocarril_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM it_ferrocarriles.ferrocarril_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7329 (class 2618 OID 2453377)
-- Name: via_ruta_a omitir_duplicados; Type: RULE; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO it_transporte_terrestre.via_ruta_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM it_transporte_terrestre.via_ruta_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7330 (class 2618 OID 2453379)
-- Name: sendero_l omitir_duplicados; Type: RULE; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO it_transporte_terrestre.sendero_l
   WHERE (0 <> ( SELECT count(*) AS count
           FROM it_transporte_terrestre.sendero_l a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7331 (class 2618 OID 2453381)
-- Name: rodera_l omitir_duplicados; Type: RULE; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO it_transporte_terrestre.rodera_l
   WHERE (0 <> ( SELECT count(*) AS count
           FROM it_transporte_terrestre.rodera_l a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7332 (class 2618 OID 2453383)
-- Name: intercambiador_vial_a omitir_duplicados; Type: RULE; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO it_transporte_terrestre.intercambiador_vial_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM it_transporte_terrestre.intercambiador_vial_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7333 (class 2618 OID 2453385)
-- Name: gasolinera_a omitir_duplicados; Type: RULE; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO it_transporte_terrestre.gasolinera_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM it_transporte_terrestre.gasolinera_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7014 (class 2606 OID 2453387)
-- Name: aeropuerto_a aeropuerto_a_fk; Type: FK CONSTRAINT; Schema: a_aeropuerto_superficie; Owner: postgres
--

ALTER TABLE ONLY a_aeropuerto_superficie.aeropuerto_a
    ADD CONSTRAINT aeropuerto_a_fk FOREIGN KEY (acc) REFERENCES catalogo_objetos.acc(acc);


--
-- TOC entry 7015 (class 2606 OID 2453392)
-- Name: aeropuerto_a aeropuerto_a_fk1; Type: FK CONSTRAINT; Schema: a_aeropuerto_superficie; Owner: postgres
--

ALTER TABLE ONLY a_aeropuerto_superficie.aeropuerto_a
    ADD CONSTRAINT aeropuerto_a_fk1 FOREIGN KEY (fuc) REFERENCES catalogo_objetos.fuc(fuc);


--
-- TOC entry 7016 (class 2606 OID 2453397)
-- Name: aeropuerto_a aeropuerto_a_fk2; Type: FK CONSTRAINT; Schema: a_aeropuerto_superficie; Owner: postgres
--

ALTER TABLE ONLY a_aeropuerto_superficie.aeropuerto_a
    ADD CONSTRAINT aeropuerto_a_fk2 FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7017 (class 2606 OID 2453402)
-- Name: punto_control_p punto_control_p_fk; Type: FK CONSTRAINT; Schema: d_linderos_propiedad; Owner: postgres
--

ALTER TABLE ONLY d_linderos_propiedad.punto_control_p
    ADD CONSTRAINT punto_control_p_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7018 (class 2606 OID 2453407)
-- Name: punto_control_p punto_control_p_fk1; Type: FK CONSTRAINT; Schema: d_linderos_propiedad; Owner: postgres
--

ALTER TABLE ONLY d_linderos_propiedad.punto_control_p
    ADD CONSTRAINT punto_control_p_fk1 FOREIGN KEY (acc) REFERENCES catalogo_objetos.acc(acc);


--
-- TOC entry 7019 (class 2606 OID 2453412)
-- Name: punto_control_p punto_control_p_fk2; Type: FK CONSTRAINT; Schema: d_linderos_propiedad; Owner: postgres
--

ALTER TABLE ONLY d_linderos_propiedad.punto_control_p
    ADD CONSTRAINT punto_control_p_fk2 FOREIGN KEY (ela) REFERENCES catalogo_objetos.ela(ela);


--
-- TOC entry 7020 (class 2606 OID 2453417)
-- Name: cementerio_a cementerio_a_fk; Type: FK CONSTRAINT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.cementerio_a
    ADD CONSTRAINT cementerio_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7021 (class 2606 OID 2453422)
-- Name: cementerio_a cementerio_a_fk1; Type: FK CONSTRAINT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.cementerio_a
    ADD CONSTRAINT cementerio_a_fk1 FOREIGN KEY (rel) REFERENCES catalogo_objetos.rel(rel);


--
-- TOC entry 7022 (class 2606 OID 2453427)
-- Name: cerca_l cerca_l_fk; Type: FK CONSTRAINT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.cerca_l
    ADD CONSTRAINT cerca_l_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7023 (class 2606 OID 2453432)
-- Name: cerca_l cerca_l_fk1; Type: FK CONSTRAINT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.cerca_l
    ADD CONSTRAINT cerca_l_fk1 FOREIGN KEY (fti) REFERENCES catalogo_objetos.fti(fti);


--
-- TOC entry 7024 (class 2606 OID 2453437)
-- Name: cerca_l cerca_l_fk2; Type: FK CONSTRAINT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.cerca_l
    ADD CONSTRAINT cerca_l_fk2 FOREIGN KEY (wti) REFERENCES catalogo_objetos.wti(wti);


--
-- TOC entry 7025 (class 2606 OID 2453442)
-- Name: escalinata_a escalinata_a_fk; Type: FK CONSTRAINT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.escalinata_a
    ADD CONSTRAINT escalinata_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7026 (class 2606 OID 2453447)
-- Name: escalinata_a escalinata_a_fk1; Type: FK CONSTRAINT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.escalinata_a
    ADD CONSTRAINT escalinata_a_fk1 FOREIGN KEY (smc) REFERENCES catalogo_objetos.smc(smc);


--
-- TOC entry 7027 (class 2606 OID 2453452)
-- Name: muro_l muro_l_fk; Type: FK CONSTRAINT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.muro_l
    ADD CONSTRAINT muro_l_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7028 (class 2606 OID 2453457)
-- Name: muro_l muro_l_fk1; Type: FK CONSTRAINT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.muro_l
    ADD CONSTRAINT muro_l_fk1 FOREIGN KEY (wti) REFERENCES catalogo_objetos.wti(wti);


--
-- TOC entry 7029 (class 2606 OID 2453462)
-- Name: plaza_publica_a plaza_publica_a_fk; Type: FK CONSTRAINT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.plaza_publica_a
    ADD CONSTRAINT plaza_publica_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7030 (class 2606 OID 2453467)
-- Name: plaza_publica_a plaza_publica_a_fk1; Type: FK CONSTRAINT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.plaza_publica_a
    ADD CONSTRAINT plaza_publica_a_fk1 FOREIGN KEY (smc) REFERENCES catalogo_objetos.smc(smc);


--
-- TOC entry 7031 (class 2606 OID 2453472)
-- Name: edificio_a edificio_a_fk; Type: FK CONSTRAINT; Schema: gs_construcciones; Owner: postgres
--

ALTER TABLE ONLY gs_construcciones.edificio_a
    ADD CONSTRAINT edificio_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7032 (class 2606 OID 2453477)
-- Name: edificio_a edificio_a_fk1; Type: FK CONSTRAINT; Schema: gs_construcciones; Owner: postgres
--

ALTER TABLE ONLY gs_construcciones.edificio_a
    ADD CONSTRAINT edificio_a_fk1 FOREIGN KEY (acc) REFERENCES catalogo_objetos.acc(acc);


--
-- TOC entry 7033 (class 2606 OID 2453482)
-- Name: edificio_a edificio_a_fk2; Type: FK CONSTRAINT; Schema: gs_construcciones; Owner: postgres
--

ALTER TABLE ONLY gs_construcciones.edificio_a
    ADD CONSTRAINT edificio_a_fk2 FOREIGN KEY (uuc) REFERENCES catalogo_objetos.uuc(uuc);


--
-- TOC entry 7034 (class 2606 OID 2453487)
-- Name: cancha_a cancha_a_fk; Type: FK CONSTRAINT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.cancha_a
    ADD CONSTRAINT cancha_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7035 (class 2606 OID 2453492)
-- Name: cancha_a cancha_a_fk1; Type: FK CONSTRAINT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.cancha_a
    ADD CONSTRAINT cancha_a_fk1 FOREIGN KEY (smc) REFERENCES catalogo_objetos.smc(smc);


--
-- TOC entry 7036 (class 2606 OID 2453497)
-- Name: cancha_a cancha_a_fk2; Type: FK CONSTRAINT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.cancha_a
    ADD CONSTRAINT cancha_a_fk2 FOREIGN KEY (kos) REFERENCES catalogo_objetos.kos(kos);


--
-- TOC entry 7037 (class 2606 OID 2453502)
-- Name: estadio_a estadio_a_fk; Type: FK CONSTRAINT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.estadio_a
    ADD CONSTRAINT estadio_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7038 (class 2606 OID 2453507)
-- Name: estadio_a estadio_a_fk1; Type: FK CONSTRAINT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.estadio_a
    ADD CONSTRAINT estadio_a_fk1 FOREIGN KEY (acc) REFERENCES catalogo_objetos.acc(acc);


--
-- TOC entry 7039 (class 2606 OID 2453512)
-- Name: parque_a parque_a_fk; Type: FK CONSTRAINT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.parque_a
    ADD CONSTRAINT parque_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7040 (class 2606 OID 2453517)
-- Name: parque_a parque_a_fk1; Type: FK CONSTRAINT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.parque_a
    ADD CONSTRAINT parque_a_fk1 FOREIGN KEY (fuc) REFERENCES catalogo_objetos.fuc(fuc);


--
-- TOC entry 7041 (class 2606 OID 2453522)
-- Name: piscina_a piscina_a_fk; Type: FK CONSTRAINT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.piscina_a
    ADD CONSTRAINT piscina_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7042 (class 2606 OID 2453527)
-- Name: plaza_toros_a plaza_toros_a_fk; Type: FK CONSTRAINT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.plaza_toros_a
    ADD CONSTRAINT plaza_toros_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7043 (class 2606 OID 2453532)
-- Name: acequia_l acequia_l_fk; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.acequia_l
    ADD CONSTRAINT acequia_l_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7044 (class 2606 OID 2453537)
-- Name: acequia_l acequia_l_fk1; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.acequia_l
    ADD CONSTRAINT acequia_l_fk1 FOREIGN KEY (hyp) REFERENCES catalogo_objetos.hyp(hyp);


--
-- TOC entry 7045 (class 2606 OID 2453542)
-- Name: acequia_l acequia_l_fk2; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.acequia_l
    ADD CONSTRAINT acequia_l_fk2 FOREIGN KEY (dit) REFERENCES catalogo_objetos.dit(dit);


--
-- TOC entry 7046 (class 2606 OID 2453547)
-- Name: acueducto_canal_a acueducto_canal_a_fk; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.acueducto_canal_a
    ADD CONSTRAINT acueducto_canal_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7047 (class 2606 OID 2453552)
-- Name: acueducto_canal_a acueducto_canal_a_fk1; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.acueducto_canal_a
    ADD CONSTRAINT acueducto_canal_a_fk1 FOREIGN KEY (atc) REFERENCES catalogo_objetos.atc(atc);


--
-- TOC entry 7048 (class 2606 OID 2453557)
-- Name: acueducto_canal_a acueducto_canal_a_fk2; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.acueducto_canal_a
    ADD CONSTRAINT acueducto_canal_a_fk2 FOREIGN KEY (smc) REFERENCES catalogo_objetos.smc(smc);


--
-- TOC entry 7049 (class 2606 OID 2453562)
-- Name: lago_laguna_a lago_laguna_a_fk; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.lago_laguna_a
    ADD CONSTRAINT lago_laguna_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7050 (class 2606 OID 2453567)
-- Name: lago_laguna_a lago_laguna_a_fk1; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.lago_laguna_a
    ADD CONSTRAINT lago_laguna_a_fk1 FOREIGN KEY (hyp) REFERENCES catalogo_objetos.hyp(hyp);


--
-- TOC entry 7051 (class 2606 OID 2453572)
-- Name: rio_a rio_a_fk; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.rio_a
    ADD CONSTRAINT rio_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7052 (class 2606 OID 2453577)
-- Name: rio_a rio_a_fk1; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.rio_a
    ADD CONSTRAINT rio_a_fk1 FOREIGN KEY (acc) REFERENCES catalogo_objetos.acc(acc);


--
-- TOC entry 7053 (class 2606 OID 2453582)
-- Name: rio_a rio_a_fk2; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.rio_a
    ADD CONSTRAINT rio_a_fk2 FOREIGN KEY (hyp) REFERENCES catalogo_objetos.hyp(hyp);


--
-- TOC entry 7054 (class 2606 OID 2453587)
-- Name: rio_l rio_l_fk; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.rio_l
    ADD CONSTRAINT rio_l_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7055 (class 2606 OID 2453592)
-- Name: rio_l rio_l_fk1; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.rio_l
    ADD CONSTRAINT rio_l_fk1 FOREIGN KEY (acc) REFERENCES catalogo_objetos.acc(acc);


--
-- TOC entry 7056 (class 2606 OID 2453597)
-- Name: rio_l rio_l_fk2; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.rio_l
    ADD CONSTRAINT rio_l_fk2 FOREIGN KEY (hyp) REFERENCES catalogo_objetos.hyp(hyp);


--
-- TOC entry 7057 (class 2606 OID 2453602)
-- Name: zanja_l zanja_l_fk; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.zanja_l
    ADD CONSTRAINT zanja_l_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7058 (class 2606 OID 2453607)
-- Name: zanja_l zanja_l_fk1; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.zanja_l
    ADD CONSTRAINT zanja_l_fk1 FOREIGN KEY (hyp) REFERENCES catalogo_objetos.hyp(hyp);


--
-- TOC entry 7059 (class 2606 OID 2453612)
-- Name: puerto_a puerto_a_fk; Type: FK CONSTRAINT; Schema: ho_puertos_muelles; Owner: postgres
--

ALTER TABLE ONLY ho_puertos_muelles.puerto_a
    ADD CONSTRAINT puerto_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7060 (class 2606 OID 2453617)
-- Name: granja_acuatica_a granja_acuatica_a_fk; Type: FK CONSTRAINT; Schema: ho_regulacion_zonas_restringidas; Owner: postgres
--

ALTER TABLE ONLY ho_regulacion_zonas_restringidas.granja_acuatica_a
    ADD CONSTRAINT granja_acuatica_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7061 (class 2606 OID 2453622)
-- Name: isla_a isla_a_fk; Type: FK CONSTRAINT; Schema: ho_zonas_costeras; Owner: postgres
--

ALTER TABLE ONLY ho_zonas_costeras.isla_a
    ADD CONSTRAINT isla_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7062 (class 2606 OID 2453627)
-- Name: orilla_l orilla_l_fk; Type: FK CONSTRAINT; Schema: ho_zonas_costeras; Owner: postgres
--

ALTER TABLE ONLY ho_zonas_costeras.orilla_l
    ADD CONSTRAINT orilla_l_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7063 (class 2606 OID 2453632)
-- Name: orilla_l orilla_l_fk1; Type: FK CONSTRAINT; Schema: ho_zonas_costeras; Owner: postgres
--

ALTER TABLE ONLY ho_zonas_costeras.orilla_l
    ADD CONSTRAINT orilla_l_fk1 FOREIGN KEY (acc) REFERENCES catalogo_objetos.acc(acc);


--
-- TOC entry 7064 (class 2606 OID 2453637)
-- Name: orilla_l orilla_l_fk2; Type: FK CONSTRAINT; Schema: ho_zonas_costeras; Owner: postgres
--

ALTER TABLE ONLY ho_zonas_costeras.orilla_l
    ADD CONSTRAINT orilla_l_fk2 FOREIGN KEY (slt) REFERENCES catalogo_objetos.slt(slt);


--
-- TOC entry 7065 (class 2606 OID 2453642)
-- Name: invernadero_a invernadero_a_fk; Type: FK CONSTRAINT; Schema: ii_agropecuaria; Owner: postgres
--

ALTER TABLE ONLY ii_agropecuaria.invernadero_a
    ADD CONSTRAINT invernadero_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7066 (class 2606 OID 2453647)
-- Name: acera_a acera_a_fk; Type: FK CONSTRAINT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.acera_a
    ADD CONSTRAINT acera_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7067 (class 2606 OID 2453652)
-- Name: acera_a acera_a_fk1; Type: FK CONSTRAINT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.acera_a
    ADD CONSTRAINT acera_a_fk1 FOREIGN KEY (smc) REFERENCES catalogo_objetos.smc(smc);


--
-- TOC entry 7068 (class 2606 OID 2453657)
-- Name: bordillo_l bordillo_l_fk; Type: FK CONSTRAINT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.bordillo_l
    ADD CONSTRAINT bordillo_l_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7069 (class 2606 OID 2453662)
-- Name: bordillo_l bordillo_l_fk1; Type: FK CONSTRAINT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.bordillo_l
    ADD CONSTRAINT bordillo_l_fk1 FOREIGN KEY (smc) REFERENCES catalogo_objetos.smc(smc);


--
-- TOC entry 7070 (class 2606 OID 2453667)
-- Name: cuneta_a cuneta_a_fk; Type: FK CONSTRAINT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.cuneta_a
    ADD CONSTRAINT cuneta_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7071 (class 2606 OID 2453672)
-- Name: cuneta_a cuneta_a_fk1; Type: FK CONSTRAINT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.cuneta_a
    ADD CONSTRAINT cuneta_a_fk1 FOREIGN KEY (smc) REFERENCES catalogo_objetos.smc(smc);


--
-- TOC entry 7072 (class 2606 OID 2453677)
-- Name: parqueadero_a parqueadero_a_fk; Type: FK CONSTRAINT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.parqueadero_a
    ADD CONSTRAINT parqueadero_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7073 (class 2606 OID 2453682)
-- Name: parqueadero_a parqueadero_a_fk1; Type: FK CONSTRAINT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.parqueadero_a
    ADD CONSTRAINT parqueadero_a_fk1 FOREIGN KEY (smc) REFERENCES catalogo_objetos.smc(smc);


--
-- TOC entry 7074 (class 2606 OID 2453687)
-- Name: paseo_peatonal_ciclovia_a paseo_peatonal_ciclovia_a_fk; Type: FK CONSTRAINT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.paseo_peatonal_ciclovia_a
    ADD CONSTRAINT paseo_peatonal_ciclovia_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7075 (class 2606 OID 2453692)
-- Name: paseo_peatonal_ciclovia_a paseo_peatonal_ciclovia_a_fk1; Type: FK CONSTRAINT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.paseo_peatonal_ciclovia_a
    ADD CONSTRAINT paseo_peatonal_ciclovia_a_fk1 FOREIGN KEY (smc) REFERENCES catalogo_objetos.smc(smc);


--
-- TOC entry 7076 (class 2606 OID 2453697)
-- Name: tunel_a tunel_a_fk; Type: FK CONSTRAINT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.tunel_a
    ADD CONSTRAINT tunel_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7077 (class 2606 OID 2453702)
-- Name: tunel_a tunel_a_fk1; Type: FK CONSTRAINT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.tunel_a
    ADD CONSTRAINT tunel_a_fk1 FOREIGN KEY (tra) REFERENCES catalogo_objetos.tra(tra);


--
-- TOC entry 7078 (class 2606 OID 2453707)
-- Name: tunel_a tunel_a_fk2; Type: FK CONSTRAINT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.tunel_a
    ADD CONSTRAINT tunel_a_fk2 FOREIGN KEY (tuc) REFERENCES catalogo_objetos.tuc(tuc);


--
-- TOC entry 7079 (class 2606 OID 2453712)
-- Name: puente_a puente_a_fk; Type: FK CONSTRAINT; Schema: it_cruces_enlaces; Owner: postgres
--

ALTER TABLE ONLY it_cruces_enlaces.puente_a
    ADD CONSTRAINT puente_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7080 (class 2606 OID 2453717)
-- Name: puente_a puente_a_fk1; Type: FK CONSTRAINT; Schema: it_cruces_enlaces; Owner: postgres
--

ALTER TABLE ONLY it_cruces_enlaces.puente_a
    ADD CONSTRAINT puente_a_fk1 FOREIGN KEY (acc) REFERENCES catalogo_objetos.acc(acc);


--
-- TOC entry 7081 (class 2606 OID 2453722)
-- Name: puente_a puente_a_fk2; Type: FK CONSTRAINT; Schema: it_cruces_enlaces; Owner: postgres
--

ALTER TABLE ONLY it_cruces_enlaces.puente_a
    ADD CONSTRAINT puente_a_fk2 FOREIGN KEY (bsc) REFERENCES catalogo_objetos.bsc(bsc);


--
-- TOC entry 7082 (class 2606 OID 2453727)
-- Name: puente_a puente_a_fk3; Type: FK CONSTRAINT; Schema: it_cruces_enlaces; Owner: postgres
--

ALTER TABLE ONLY it_cruces_enlaces.puente_a
    ADD CONSTRAINT puente_a_fk3 FOREIGN KEY (typ) REFERENCES catalogo_objetos.typ(typ);


--
-- TOC entry 7083 (class 2606 OID 2453732)
-- Name: puente_a puente_a_fk4; Type: FK CONSTRAINT; Schema: it_cruces_enlaces; Owner: postgres
--

ALTER TABLE ONLY it_cruces_enlaces.puente_a
    ADD CONSTRAINT puente_a_fk4 FOREIGN KEY (tuc) REFERENCES catalogo_objetos.tuc(tuc);


--
-- TOC entry 7084 (class 2606 OID 2453737)
-- Name: ferrocarril_a ferrocarril_a_fk; Type: FK CONSTRAINT; Schema: it_ferrocarriles; Owner: postgres
--

ALTER TABLE ONLY it_ferrocarriles.ferrocarril_a
    ADD CONSTRAINT ferrocarril_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7085 (class 2606 OID 2453742)
-- Name: ferrocarril_a ferrocarril_a_fk1; Type: FK CONSTRAINT; Schema: it_ferrocarriles; Owner: postgres
--

ALTER TABLE ONLY it_ferrocarriles.ferrocarril_a
    ADD CONSTRAINT ferrocarril_a_fk1 FOREIGN KEY (acc) REFERENCES catalogo_objetos.acc(acc);


--
-- TOC entry 7086 (class 2606 OID 2453747)
-- Name: ferrocarril_a ferrocarril_a_fk2; Type: FK CONSTRAINT; Schema: it_ferrocarriles; Owner: postgres
--

ALTER TABLE ONLY it_ferrocarriles.ferrocarril_a
    ADD CONSTRAINT ferrocarril_a_fk2 FOREIGN KEY (fco) REFERENCES catalogo_objetos.fco(fco);


--
-- TOC entry 7087 (class 2606 OID 2453752)
-- Name: ferrocarril_a ferrocarril_a_fk3; Type: FK CONSTRAINT; Schema: it_ferrocarriles; Owner: postgres
--

ALTER TABLE ONLY it_ferrocarriles.ferrocarril_a
    ADD CONSTRAINT ferrocarril_a_fk3 FOREIGN KEY (loc) REFERENCES catalogo_objetos.loc(loc);


--
-- TOC entry 7088 (class 2606 OID 2453757)
-- Name: ferrocarril_a ferrocarril_a_fk4; Type: FK CONSTRAINT; Schema: it_ferrocarriles; Owner: postgres
--

ALTER TABLE ONLY it_ferrocarriles.ferrocarril_a
    ADD CONSTRAINT ferrocarril_a_fk4 FOREIGN KEY (rgc) REFERENCES catalogo_objetos.rgc(rgc);


--
-- TOC entry 7089 (class 2606 OID 2453762)
-- Name: ferrocarril_a ferrocarril_a_fk5; Type: FK CONSTRAINT; Schema: it_ferrocarriles; Owner: postgres
--

ALTER TABLE ONLY it_ferrocarriles.ferrocarril_a
    ADD CONSTRAINT ferrocarril_a_fk5 FOREIGN KEY (rra) REFERENCES catalogo_objetos.rra(rra);


--
-- TOC entry 7090 (class 2606 OID 2453767)
-- Name: ferrocarril_a ferrocarril_a_fk6; Type: FK CONSTRAINT; Schema: it_ferrocarriles; Owner: postgres
--

ALTER TABLE ONLY it_ferrocarriles.ferrocarril_a
    ADD CONSTRAINT ferrocarril_a_fk6 FOREIGN KEY (rrc) REFERENCES catalogo_objetos.rrc(rrc);


--
-- TOC entry 7091 (class 2606 OID 2453772)
-- Name: gasolinera_a gasolinera_a_fk; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.gasolinera_a
    ADD CONSTRAINT gasolinera_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7092 (class 2606 OID 2453777)
-- Name: intercambiador_vial_a intercambiador_vial_a_fk; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.intercambiador_vial_a
    ADD CONSTRAINT intercambiador_vial_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7093 (class 2606 OID 2453782)
-- Name: intercambiador_vial_a intercambiador_vial_a_fk1; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.intercambiador_vial_a
    ADD CONSTRAINT intercambiador_vial_a_fk1 FOREIGN KEY (hct) REFERENCES catalogo_objetos.hct(hct);


--
-- TOC entry 7094 (class 2606 OID 2453787)
-- Name: intercambiador_vial_a intercambiador_vial_a_fk2; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.intercambiador_vial_a
    ADD CONSTRAINT intercambiador_vial_a_fk2 FOREIGN KEY (rst) REFERENCES catalogo_objetos.rst(rst);


--
-- TOC entry 7095 (class 2606 OID 2453792)
-- Name: intercambiador_vial_a intercambiador_vial_a_fk3; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.intercambiador_vial_a
    ADD CONSTRAINT intercambiador_vial_a_fk3 FOREIGN KEY (loc) REFERENCES catalogo_objetos.loc(loc);


--
-- TOC entry 7096 (class 2606 OID 2453797)
-- Name: rodera_l rodera_l_fk; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.rodera_l
    ADD CONSTRAINT rodera_l_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7097 (class 2606 OID 2453802)
-- Name: rodera_l rodera_l_fk1; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.rodera_l
    ADD CONSTRAINT rodera_l_fk1 FOREIGN KEY (typ) REFERENCES catalogo_objetos.typ(typ);


--
-- TOC entry 7098 (class 2606 OID 2453807)
-- Name: rodera_l rodera_l_fk2; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.rodera_l
    ADD CONSTRAINT rodera_l_fk2 FOREIGN KEY (rst) REFERENCES catalogo_objetos.rst(rst);


--
-- TOC entry 7099 (class 2606 OID 2453812)
-- Name: rodera_l rodera_l_fk3; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.rodera_l
    ADD CONSTRAINT rodera_l_fk3 FOREIGN KEY (hct) REFERENCES catalogo_objetos.hct(hct);


--
-- TOC entry 7100 (class 2606 OID 2453817)
-- Name: rodera_l rodera_l_fk4; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.rodera_l
    ADD CONSTRAINT rodera_l_fk4 FOREIGN KEY (rdt) REFERENCES catalogo_objetos.rdt(rdt);


--
-- TOC entry 7101 (class 2606 OID 2453822)
-- Name: rodera_l rodera_l_fk5; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.rodera_l
    ADD CONSTRAINT rodera_l_fk5 FOREIGN KEY (wtc) REFERENCES catalogo_objetos.wtc(wtc);


--
-- TOC entry 7102 (class 2606 OID 2453827)
-- Name: rodera_l rodera_l_fk6; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.rodera_l
    ADD CONSTRAINT rodera_l_fk6 FOREIGN KEY (tuc) REFERENCES catalogo_objetos.tuc(tuc);


--
-- TOC entry 7103 (class 2606 OID 2453832)
-- Name: sendero_l sendero_l_fk; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.sendero_l
    ADD CONSTRAINT sendero_l_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7104 (class 2606 OID 2453837)
-- Name: sendero_l sendero_l_fk1; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.sendero_l
    ADD CONSTRAINT sendero_l_fk1 FOREIGN KEY (wtc) REFERENCES catalogo_objetos.wtc(wtc);


--
-- TOC entry 7105 (class 2606 OID 2453842)
-- Name: via_ruta_a via_ruta_a_fk; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.via_ruta_a
    ADD CONSTRAINT via_ruta_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7106 (class 2606 OID 2453847)
-- Name: via_ruta_a via_ruta_a_fk1; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.via_ruta_a
    ADD CONSTRAINT via_ruta_a_fk1 FOREIGN KEY (acc) REFERENCES catalogo_objetos.acc(acc);


--
-- TOC entry 7107 (class 2606 OID 2453852)
-- Name: via_ruta_a via_ruta_a_fk2; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.via_ruta_a
    ADD CONSTRAINT via_ruta_a_fk2 FOREIGN KEY (rst) REFERENCES catalogo_objetos.rst(rst);


--
-- TOC entry 7108 (class 2606 OID 2453857)
-- Name: via_ruta_a via_ruta_a_fk3; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.via_ruta_a
    ADD CONSTRAINT via_ruta_a_fk3 FOREIGN KEY (typ) REFERENCES catalogo_objetos.typ(typ);


--
-- TOC entry 7109 (class 2606 OID 2453862)
-- Name: via_ruta_a via_ruta_a_fk4; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.via_ruta_a
    ADD CONSTRAINT via_ruta_a_fk4 FOREIGN KEY (hct) REFERENCES catalogo_objetos.hct(hct);


--
-- TOC entry 7110 (class 2606 OID 2453867)
-- Name: via_ruta_a via_ruta_a_fk5; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.via_ruta_a
    ADD CONSTRAINT via_ruta_a_fk5 FOREIGN KEY (loc) REFERENCES catalogo_objetos.loc(loc);


--
-- TOC entry 7111 (class 2606 OID 2453872)
-- Name: via_ruta_a via_ruta_a_fk6; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.via_ruta_a
    ADD CONSTRAINT via_ruta_a_fk6 FOREIGN KEY (mes) REFERENCES catalogo_objetos.mes(mes);


--
-- TOC entry 7112 (class 2606 OID 2453877)
-- Name: via_ruta_a via_ruta_a_fk7; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.via_ruta_a
    ADD CONSTRAINT via_ruta_a_fk7 FOREIGN KEY (rdt) REFERENCES catalogo_objetos.rdt(rdt);


--
-- TOC entry 7113 (class 2606 OID 2453882)
-- Name: via_ruta_a via_ruta_a_fk8; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.via_ruta_a
    ADD CONSTRAINT via_ruta_a_fk8 FOREIGN KEY (tuc) REFERENCES catalogo_objetos.tuc(tuc);


-- Completed on 2022-08-24 08:06:34

--
-- PostgreSQL database dump complete
--

